#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, \
    get_file_system_id_vstore_id_mapping, vstore_id_to_sort, get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_NAME
from storages.HUAWEI.huawei_storage_util import parse_table_type_result


def execute(context):
    """
    获取V3/V5 文件系统Worm信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Filesystem ID", "Filesystem Name", "Capacity", "Type", "Worm Type",
                   "Worm Minimal Protect Period", "Worm Maximal Protect Period", "Worm Default Protect Period",
                   "Worm Auto Lock", "Worm Auto Lock Time", "Worm Auto Delete", "Worm Clock Time", "Worm Expired Time"]
    parse_data(context, [data_header], get_worm_file_system_content)


def get_worm_file_system_content(context):
    data_content = []
    file_sys_id_vstore_id_map = get_file_system_id_vstore_id_mapping(context)
    id_name_map = get_vstore_id_name_mapping(context)
    worm_file_sys_table_lines = get_command_result_lines(context, "cmd_display_admin_file_system_worm")
    table_data = parse_table_type_result(worm_file_sys_table_lines)
    for data in table_data:
        worm_file_sys_id = data.get("ID")
        vstore_id = file_sys_id_vstore_id_map.get(worm_file_sys_id)
        # id_name_map没有默认租户"--"的映射，默认租户返回"System Vstore"
        vstore_name = id_name_map.get(vstore_id, SYSTEM_VSTORE_NAME)
        des = "cmd_display_worm_file_system_id=%s" % worm_file_sys_id
        data_dict = get_key_value_type_result(context, des, ":")
        row_data = build_row_data(vstore_id, vstore_name, data_dict)
        data_content.append(row_data)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_row_data(vstore_id, vstore_name, data_dict):
    return [vstore_id, vstore_name, data_dict.get("ID"), data_dict.get("Name"), data_dict.get("Capacity"),
            data_dict.get("Type"), data_dict.get("Worm Type"), data_dict.get("Worm Minimal Protect Period"),
            data_dict.get("Worm Maximal Protect Period"), data_dict.get("Worm Default Protect Period"),
            data_dict.get("Worm Auto Lock"), data_dict.get("Worm Auto Lock Time"), data_dict.get("Worm Auto Delete"),
            data_dict.get("Worm Clock Time"), data_dict.get("Worm Expired Time")]
