#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import traceback
from storages.storage_common import format_analysis_result, SYSTEM_INFO_KEYS, get_default_empty_system_info, NA
from storages.storage_common import parse_data_dict
from storages.storage_common import get_command_result_lines
from storages.HUAWEI.huawei_storage_util import parse_key_value_type_result
from storages.HUAWEI.huawei_storage_util import get_storage_series
from storages.HUAWEI.huawei_storage_util import get_device_class


def execute(context):
    """
    入口执行方法
    :param context: 上下文数据
    :return: context
    """
    try:
        dev_class = get_device_class(context)
        if dev_class == "TV1":
            sys_infos = get_tv1_system_info(context)
        else:
            sys_infos = get_common_system_info(context)
        sys_data = parse_data_dict(SYSTEM_INFO_KEYS, sys_infos)
        return format_analysis_result(context, [sys_data])
    except Exception:
        context["error"] = "huawei analysis sys info error: %s" % str(traceback.format_exc())
        return format_analysis_result(context, get_default_empty_system_info())


def get_tv1_system_info(context):
    """
    获取TV1类型设备的系统信息
    :param context: 系统信息回显行
    :return: []，与system_info_keys对应
    """
    sys_info_lines = get_command_result_lines(context, "cmd_display_huawei_sys_info")
    sys_info_dict = parse_key_value_type_result(sys_info_lines, " | ")
    dev_type = get_device_type(sys_info_dict.get("Device Type", ""))
    return [NA, NA, "Huawei", get_storage_series(dev_type), dev_type, sys_info_dict.get("Product Version", ""),
            sys_info_dict.get("Device Serial Number", ""), NA]


def get_common_system_info(context):
    """
    获取通用类型设备的系统信息
    :param context: 系统信息回显行
    :return: []，与system_info_keys对应
    """
    sys_info_lines = get_command_result_lines(context, "cmd_display_huawei_sys_info")
    sys_info_dict = parse_key_value_type_result(sys_info_lines, " : ")
    dev_type = get_device_type(sys_info_dict.get("Product Model", ""))
    return [NA, NA, "Huawei", (get_storage_series(dev_type)), dev_type, sys_info_dict.get("Product Version", ""),
            sys_info_dict.get("SN", ""), NA]


def get_device_type(device_type):
    """
    若设备类型没有OceanStor，自动拼接
    :param device_type: 采集的设备型号
    :return: OceanStor xxx
    """
    if not device_type.lower().startswith("oceanstor"):
        return "OceanStor " + device_type
    return device_type
