# --*-- coding:utf-8 --*--
import sys
import os
import re
from cmd import Cmd

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)

from common.contentParse import getValueFMap
from common.contentParse import style
from common.contentParse import addValueToMap
from common.contentParse import get_jsonarr_name
from common.contentParse import get_jsonstr
from common.contentParse import get_purecommands_lst
from common.contentParse import get_comdslst_byfile
from common.contentParse import get_attrlst_dic


global key_lst  # 对应Excel中属性列表
global attribute_arr  # 从传入的命令中获取的属性列表
global value_lst
global context

# 对应excel中的属性字段
key_lst = [
    'mapping_view_id', 'mapping_view_name', 'lun_group_id', 'lun_group_name', 'lun_id', 'lun_name', 'capacity',
    'host_id', 'hostgroup_id', 'status', 'lun_wwn', 'lun_type'
]


# 获取Linux主机集群 Server信息
def execute(context):
    # 获取回文
    # start
    path = getValueFMap(context, style, 'path')
    command = getValueFMap(context, style, 'command').strip()
    attribute_arr = []
    value_lst = []

    addValueToMap(context, style, 'command', command)
    attrcom_dic = get_attrcom_dicv2(context)
    # 对应execel属性名
    json_attr_name = get_jsonarr_name(attrcom_dic)
    attr_valuelst_dic = get_attrvalue_dic(context, attrcom_dic)
    # 获取attribute ,value_lst
    # 获取json结果字符串
    lunobj_list = get_lun_basic(attr_valuelst_dic)
    lunobj_list = get_lun_cap(lunobj_list, attr_valuelst_dic)

    for key in key_lst:
        for attr in attr_valuelst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)

    lunobj = Lun_Entity()
    for lunobj in lunobj_list:
        value_lst.append('NA')
        value_lst.append('NA')
        value_lst.append('NA')
        value_lst.append('NA')
        value_lst.append(lunobj.get_id())
        value_lst.append(lunobj.get_name())
        value_lst.append(lunobj.get_capacity())
        value_lst.append('NA')
        value_lst.append(str(lunobj.get_hostgroupid()))
        value_lst.append(lunobj.get_status())
        value_lst.append(lunobj.get_wwn())
        value_lst.append(lunobj.get_type())
    result = get_jsonstr(json_attr_name, attribute_arr, value_lst)
    addValueToMap(context, style, 'result', result)
    return context


def get_lun_basic(txt):
    vvdetail_list = txt.get(key_lst[4])[3:-1]

    # 多个主机下，映射完全一致的Lun，视为这些主机为同一个主机组，生成一个字典dic{hostid:{"hostgid": hostgid, "hostgname": hostgname}}
    dic = {}  # 获取{hostid:lun[]}
    for line in vvdetail_list:
        items = line.split(":")
        if items[0] in dic:
            dic[items[0]].append(items[3])
        else:
            dic[items[0]] = [items[3]]

    hostgid = 0
    for lunobj in dic:
        if type(dic[lunobj]) != type([]):
            continue
        hostgid = hostgid + 1
        hostgname = "HostGroup" + str(hostgid)
        listTemp = dic[lunobj]
        dic[lunobj] = {"hostgid": hostgid, "hostgname": hostgname}
        for j in dic:
            if type(dic[j]) != type([]):
                continue
            if len(list(set(listTemp).difference(set(dic[j])))) == 0 and len(
                    list(set(dic[j]).difference(set(listTemp)))) == 0:
                dic[j] = {"hostgid": hostgid, "hostgname": hostgname}

    # 生成lun对象列表，赋予hostgid
    lun_obj_list = []
    for line in vvdetail_list:
        lunobj = Lun_Entity()
        vvdetail_temp = re.split(':', line)
        if len(vvdetail_temp) >= 6:
            lunobj.set_hostgroupid(dic[vvdetail_temp[0]]["hostgid"])
            lunobj.set_id(vvdetail_temp[3])
            lunobj.set_name(vvdetail_temp[4])
            lunobj.set_wwn(vvdetail_temp[5])
            lun_obj_list.append(lunobj)

    # 对lun对象列表进行处理，当lunid相同&&hostgid相同，视为属于同一个映射组，只保留一个即可（lunid----属于的主机组，重复则过滤掉）
    lunid_hostgid_dic = {}
    last_lun_obj_list = []
    for lunobj in lun_obj_list:
        if lunobj.get_id() not in lunid_hostgid_dic.keys():
            lungid = []
            lungid.append(lunobj.get_hostgroupid())
            lunid_hostgid_dic[lunobj.get_id()] = lungid
            last_lun_obj_list.append(lunobj)
        elif lunobj.get_hostgroupid() not in lunid_hostgid_dic[lunobj.get_id()]:
            lunid_hostgid_dic[lunobj.get_id()].append(lunobj.get_hostgroupid())
            last_lun_obj_list.append(lunobj)
        else:
            continue
    return last_lun_obj_list


def get_lun_cap(lunobj_list, txt):
    vv_list = txt.get(key_lst[6])[3:-1]
    for lunobj in lunobj_list:
        for line in vv_list:
            lun_temp = re.split(':', line)
            if len(lun_temp) >= 9:
                if lunobj.get_id() == lun_temp[0]:
                    lunobj.set_status(lun_temp[4])
                    lunobj.set_capacity(lun_temp[7])
                    lunobj.set_type(lun_temp[8])
                    break
    return lunobj_list


def get_attrvalue_dic(context, attrcom_dic):
    all_comds_lst = get_purecommands_lst(attrcom_dic)
    path = getValueFMap(context, style, 'path')
    all_comds_byfile = get_comdslst_byfile(all_comds_lst, path)
    return get_attrlst_dic(attrcom_dic, all_comds_byfile, path)


def get_attrcom_dicv2(context):
    command = getValueFMap(context, style, 'command')
    # 去除最后面的';'
    if ';' == command.strip()[-1]:
        command = command[0:-1]
    attrcom_dic = {}
    try:
        for comd in command.split(';'):
            if comd.count(':') == 1:
                lst = comd.split(':')
                key = lst[0].strip()
                if (1 < len(lst)) and (',' in lst[1]):
                    addValueToMap(attrcom_dic, style, key, lst[1].strip().split(','))
                else:
                    addValueToMap(attrcom_dic, style, key, [lst[1].strip()])
            else:
                value_lst = comd.split(':')
                key = value_lst[0].strip()
                rep = key + ':'
                value = comd.replace(rep, '')
                value = value.strip()
                addValueToMap(attrcom_dic, style, key, [value])
    except:
        raise Exception("Not Leagal ,this commands..")
    return attrcom_dic


class Host_Entity:
    __hostname = 'NA'
    __hostset = 'NA'
    __vvname = 'NA'
    __vvset = 'NA'
    __hostid = 'NA'

    # get
    def get_hostname(self):
        return self.__hostname

    def get_hostset(self):
        return self.__hostset

    def get_vvname(self):
        return self.__vvname

    def get_vvset(self):
        return self.__vvset

    def get_hostid(self):
        return self.__hostid

    # set
    def set_hostname(self, name):
        self.__hostname = name

    def set_hostset(self, hostset):
        self.__hostset = hostset

    def set_vvname(self, vvname):
        self.__vvname = vvname

    def set_vvset(self, vvset):
        self.__vvset = vvset

    def set_hostid(self, hostid):
        self.__hostid = hostid


class Lun_Entity:
    __lungroup_id = 'NA'
    __lungroup_name = 'NA'
    __lun_id = 'NA'
    __lun_name = 'NA'
    __capacity = 'NA'
    __host_id = 'NA'
    __host_groupid = 'NA'
    __status = 'NA'
    __lun_wwn = 'NA'
    __lun_type = 'NA'

    # set
    def set_groupid(self, groupid):
        self.__lungroup_id = groupid

    def set_groupname(self, groupname):
        self.__lungroup_name = groupname

    def set_id(self, id):
        self.__lun_id = id

    def set_name(self, name):
        self.__lun_name = name

    def set_capacity(self, cap):
        self.__capacity = cap

    def set_hostid(self, hostid):
        self.__host_id = hostid

    def set_hostgroupid(self, hostgroupid):
        self.__host_groupid = hostgroupid

    def set_status(self, sta):
        self.__status = sta

    def set_wwn(self, wwn):
        self.__lun_wwn = wwn

    def set_type(self, type):
        self.__lun_type = type

    # get
    def get_groupid(self):
        return self.__lungroup_id

    def get_groupname(self):
        return self.__lungroup_name

    def get_id(self):
        return self.__lun_id

    def get_name(self):
        return self.__lun_name

    def get_capacity(self):
        return self.__capacity

    def get_hostid(self):
        return self.__host_id

    def get_hostgroupid(self):
        return self.__host_groupid

    def get_status(self):
        return self.__status

    def get_wwn(self):
        return self.__lun_wwn

    def get_type(self):
        return self.__lun_type
