#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from storages.storage_common import get_command_result_lines
from storages.storage_san_constant import LUN_LIST, MV_ID, HOST_LIST

PURE_STORAGE_NA = "-"


def get_mapping_data(context):
    """
    主机/主机组为维度的视图
    :param context: 上下文
    :return: 视图 {host_name_1:{"lun_list":[lun1,lun2...],"mv_id":1},host_name_2:}
               {host_group_name_1:{"host_list":[host1,host2..],"lun_list":[lun1,lun2...],"mv_id":5},host_group_name_2:}
    """
    mapping_view_lines = get_command_result_lines(context, "purehost list --connect", True)
    index, host_mapping, group_mapping = 0, {}, {}
    for line in mapping_view_lines:
        items = line.strip().split()
        if len(items) != 4:
            continue
        host_name = items[0]
        lun_name = items[2]
        host_group_name = items[3]
        if PURE_STORAGE_NA == host_group_name:
            if host_name not in host_mapping:
                index += 1
            build_host_mapping(host_mapping, host_name, lun_name, index)
        else:
            if host_group_name not in group_mapping:
                index += 1
            build_host_group_mapping(group_mapping, host_group_name, host_name, lun_name, index)
    return host_mapping, group_mapping


def build_host_mapping(host_mapping, host_name, lun_name, index):
    """
    添加主机维度的映射
    :param host_mapping: 主机维度视图
    :param host_name: 主机名
    :param lun_name: lun名
    :param index: 视图id
    :return: 视图id
    """
    host_data = host_mapping.get(host_name, {})
    lun_list = host_data.get(LUN_LIST, [])
    index = host_data.get(MV_ID, index)
    lun_list.append(lun_name)
    host_mapping[host_name] = {LUN_LIST: lun_list, MV_ID: index}


def build_host_group_mapping(group_mapping, host_group_name, host_name, lun_name, index):
    """
    添加主机组维度的映射
    :param group_mapping: 主机组维度视图
    :param host_name: 主机名
    :param lun_name: lun名
    :param index: 视图id
    :param host_group_name: 主机组名
    :return: 视图id
    """
    host_group_data = group_mapping.get(host_group_name, {})
    host_list = host_group_data.get(HOST_LIST, [])
    lun_list = host_group_data.get(LUN_LIST, [])
    index = host_group_data.get(MV_ID, index)
    if host_name not in host_list:
        host_list.append(host_name)
    if lun_name not in lun_list:
        lun_list.append(lun_name)
    group_mapping[host_group_name] = {HOST_LIST: host_list, LUN_LIST: lun_list, MV_ID: index}
