#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from storages.PureStorage.pure_storage_san_util import PURE_STORAGE_NA, get_mapping_data
from storages.storage_common import get_storage_format_info, get_mapping_view_name, NA
from storages.storage_common import get_command_result_lines
from storages.storage_common import HostInfo
from storages.storage_san_constant import MV_ID, HOST_LIST


def execute(context):
    """
    入口执行方法
    :param context: 上下文数据
    :return: context
    """
    return get_storage_format_info(context, parse_host_info, [HostInfo().get_host_info_dict()], False)


def parse_host_info(context):
    """
    主机解析（映射视图中的）
    :param context: 上下文
    :return: [{}, ...]
    """
    all_host_list = get_all_host_list(context)
    host_mapping, group_mapping = get_mapping_data(context)
    host_list = []
    host_list.extend(parse_host_for_host_mapping(host_mapping, all_host_list))
    host_list.extend(parse_host_for_host_group_mapping(group_mapping, all_host_list))
    return host_list


def get_all_host_list(context):
    """
    主机详细信息解析
    Name                           WWN                      IQN           NQN  Host Group
    host_name1                     21:**:00:24:**:19:59:**  -             -    -
    host_name2                     10:**:00:10:**:32:A4:**  -             -    -
                                   10:**:00:10:**:32:A4:**
    host_name3                     20:**:18:3D:**:0F:51:**  -             -    -
                                   20:**:18:3D:**:0F:51:**
                                   20:**:18:3D:**:0F:51:**
                                   20:**:18:3D:**:0F:51:**
    :param context: 上下文
    :return: 主机
    """
    host_info_lines = get_command_result_lines(context, "purehost list")
    content_flag, host, host_list = False, HostInfo(), []
    for line in host_info_lines:
        if line.startswith("Name") and line.endswith("Host Group"):
            content_flag = True
            continue
        if not content_flag:
            continue
        items = line.split()
        if len(items) == 5:
            host = HostInfo()
            initiator_wwn = items[1] if PURE_STORAGE_NA != items[1] else items[2]
            host.set_host_name(items[0])
            host.set_initiator_wwn(initiator_wwn)
            host_group_name = items[4] if PURE_STORAGE_NA != items[4] else NA
            host.set_host_group_name(host_group_name)
            host_list.append(host)
            continue
        if len(items) == 1:
            host_temp = host.copy_host()
            host_temp.set_initiator_wwn(items[0])
            host_list.append(host_temp)
    return host_list


def parse_host_for_host_mapping(host_mapping, all_host_list):
    """
    解析主机维度的视图
    :param host_mapping: 映射视图
    :param all_host_list: 所有主机数据
    :return: 主机数据[{}, ...]
    """
    host_list = []
    for host_name, host_data in host_mapping.items():
        mv_id = host_data.get(MV_ID, 0)
        for host in all_host_list:
            if host_name == host.get_host_name():
                host_temp = host.copy_host()
                host_temp.set_mapping_view_id(mv_id)
                host_temp.set_mapping_view_name(get_mapping_view_name(mv_id))
                host_list.append(host_temp.get_host_info_dict())
    return host_list


def parse_host_for_host_group_mapping(group_mapping, all_host_list):
    """
    解析主机组维度的视图
    :param group_mapping: 映射视图
    :param all_host_list: 所有主机数据
    :return: 主机数据[{}, ...]
    """
    host_list = []
    for host_group_name, host_group_data in group_mapping.items():
        mv_id = host_group_data.get(MV_ID, 0)
        host_list_in_group = host_group_data.get(HOST_LIST, [])
        for host in all_host_list:
            if host.get_host_name() in host_list_in_group:
                host_temp = host.copy_host()
                host_temp.set_mapping_view_id(mv_id)
                host_temp.set_mapping_view_name(get_mapping_view_name(mv_id))
                host_list.append(host_temp.get_host_info_dict())
    return host_list
