#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from storages.storage_common import NA, get_default_empty_system_info, get_storage_format_info
from storages.storage_common import get_command_result_lines


def execute(context):
    return get_storage_format_info(context, get_system_info, get_default_empty_system_info(), True)


def get_system_info(context):
    """
    获取系统信息
    :param context: 系统信息回显行
    :return: []，与system_info_keys对应
    """
    model, version = get_model_version(context)
    return [NA, NA, "PureStorage", NA, model, version, get_sn(context), NA]


def get_model_version(context):
    """
    获取设备类型/版本
    :param context: 上下文
    :return: 设备类型/版本
    """
    cli_result = get_command_result_lines(context, "purearray list --controller")
    for line in cli_result:
        items = line.strip().split()
        if len(items) == 6 and items[1] == "array_controller":
            return items[3], items[4]
    return "", ""


def get_sn(context):
    """
    获取sn
    :param context: 上下文
    :return: sn
    """
    cli_result = get_command_result_lines(context, "purearray list")
    header_flag = False
    for line in cli_result:
        line = line.strip()
        if line.startswith("Name") and line.endswith("Version"):
            header_flag = True
            continue
        items = line.split()
        if header_flag and len(items) == 4:
            return items[1]
    return ""
