# coding=utf-8
__author__ = '******'
# 获取Brocade 交换机 hba信息
import os
import re
import sys
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import getCommandRet
from common import constants

cmd_info_id = [
               "cmd_info_brocade_allhba_wwpn_mapping",
               "cmd_info_brocade_allhba_fdmi_infos"
               ]
cmd_info_desc = [
                 "nsshow",
                 "fdmishow"
                 ]
                 

def execute(context):
    fid_lst = get_fids(context)
    if len(fid_lst)>0:
        for fid in fid_lst:
            cmd_info_id.append("cmd_info_brocade_hba_card_setcontex_"+fid)
            cmd_info_desc.append("setcontex " + fid)
            
            cmd_info_id.append("cmd_info_brocade_hba_card_wwpn_"+fid)
            cmd_info_desc.append("nsshow | grep -i \"Permanent Port Name\"")
            
            cmd_info_id.append("cmd_info_brocade_hba_card_mdlfwdv_"+fid)
            cmd_info_desc.append("nsshow | grep -i \"NodeSymb:\"")
            
            cmd_info_id.append("cmd_info_brocade_hba_card_idx_"+fid)
            cmd_info_desc.append("nsshow | grep -i \"Port Index:\"")
    else:
         cmd_info_id.append("cmd_info_brocade_hba_card_wwpn_")
         cmd_info_desc.append("nsshow | grep -i \"Permanent Port Name\"")
            
         cmd_info_id.append("cmd_info_brocade_hba_card_mdlfwdv_")
         cmd_info_desc.append("nsshow | grep -i \"NodeSymb:\"")
            
         cmd_info_id.append("cmd_info_brocade_hba_card_idx_")
         cmd_info_desc.append("nsshow | grep -i \"Port Index:\"")
    context["totalPgr"] = constants.PROG85
    return getCommandRet(context,cmd_info_id,cmd_info_desc)


def get_fids(context):
    CLI = context.get("SSH")
    fid_lst = []
    temp = CLI.execCmdHasLogTimout("lscfg --show",60)
    fidline = re.split('\n',temp)[1].strip()
    
    if("(" in fidline):
        fidline = re.split(':',fidline)[-1].strip()
        fidlst = re.split('\s\s+',fidline)
        
        for fidtemp in fidlst:
            fid = re.split('\(',fidtemp)[0].strip()
            if fid.isdigit():
                fid_lst.append(fid)
        return fid_lst
    else:
        return fid_lst


