# --*-- coding:utf-8 --*--
import sys
import os
reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import *

#Brocade 交换机，新加了一页，返回数据：wwpn,modelname,driversion,fwversion。如：
#result = "1,2 ; name1,name2; version1,version2; fw1,fw2 "
#情况一：
#Brocade_300_110_36:admin> nsshow | grep -i "Permanent Port Name"
#    Permanent Port Name: 21:00:00:1b:32:9e:83:2b
#    Permanent Port Name: 10:00:00:90:fa:92:3f:6a
#Brocade_300_110_36:admin> nsshow | grep -i "NodeSymb:"
#    NodeSymb: [42] "QLE2462 FW:v5.08.00 DVR:v8.04.00.13.11.3-k"
#    NodeSymb: [49] "Emulex LPe15002B-M8-D FV10.6.133.18 DV8.3.7.10.6p"

#情况二：
#DCX8510:FID128:admin> nsshow | grep -i "Permanent Port Name"
#    Permanent Port Name: 26:1b:84:5b:12:5f:50:bb
#    Permanent Port Name: 26:0b:84:5b:12:5f:50:bb
#    Permanent Port Name: 20:10:00:c0:dd:1f:2c:96
#    Permanent Port Name: 20:10:00:c0:dd:24:65:3e
#    Permanent Port Name: 20:10:00:c0:dd:24:65:3e
#DCX8510:FID128:admin> nsshow | grep -i "NodeSymb:"
#    NodeSymb: [33] "QMI2582 FW:v5.09.00 DVR:v1.0.12.0"
#这种情况用nsshow 命令查询

def execute(context):
    WWPN_COMD = "cmd_display_brocade_hba_card_wwpn_"
    NAMEFWDV_COMD = "cmd_display_brocade_hba_card_mdlfwdv_"
    global LOGGER
    LOGGER = context.get("Logger")

    wwpn_comd_lst = getSortedComds(context, WWPN_COMD)
    allhbawwpn_lst = get_hba_wwpn(context, wwpn_comd_lst)

    #modelName,fwversion,driversion
    namefwdv_comd_lst = getSortedComds(context, NAMEFWDV_COMD)

    allhbaline_lst = getSameCommandsHbaRetFromTxt(context, ["cmd_display_brocade_allhba_wwpn_mapping"])[0]
    newhbaobj_lst = []
    newwwpn_lst = []
    newwwpn_line_lst = []

    for idx, wwpn in enumerate(allhbaline_lst):
        name = ""
        driversion = ""
        fwversion = ""
        wwpnnew = ""

        #求hba卡对象start
        if isECard(wwpn):

            if 'emulex' in wwpn.lower():
                lst = re.split('\s', wwpn)
                for idxlst, temp in enumerate(lst):
                    if 'emulex' in temp.lower():
                        name = lst[idxlst + 1]
                        continue
                    elif temp.lower().startswith('fv'):
                        fwversion = temp[2:].strip()
                        continue
                    elif temp.lower().startswith('dv'):
                        driversion = temp[2:].strip()
                        if '"' in driversion:
                            driversion = driversion[0:-1]
                        if '.' == driversion[-1]:
                            driversion = driversion[0:-1]
                        continue
            newwwpn_line_lst = allhbaline_lst[idx:idx + 3]
            for newwwpn in newwwpn_line_lst:
                if ("Permanent".lower() in newwwpn.lower()) and ("port" in newwwpn.lower()) and ("name" in newwwpn.lower()):
                    wwpnnew = re.split('\s', newwwpn)[-1].strip()
                    break
            ehbaobj = Name_Dv_FW()
            if wwpnnew :
                ehbaobj.setModelName(name)
                ehbaobj.setDvVersion(driversion)
                ehbaobj.setFwVersion(fwversion)
                ehbaobj.setWwpn(wwpnnew)

            newhbaobj_lst.append(ehbaobj)
        #Q卡
        elif isQCard(wwpn):
            #  NodeSymb: [54] "QLE2562 FW:v8.02.00 DVR:v102.2.3.20 mark-offline-1 DBG"
            #  NodeSymb: [42] "QLE2560 FW:v7.03.00 DVR:v8.07.00.18.07.2-k"
            qhbaobj = Name_Dv_FW()

            wwpn = wwpn.replace('[', '')
            wwpn = wwpn.replace(']', '')
            wwpn = wwpn.replace('\"', '')
            lst = re.split('\s', wwpn)

            try:
                for temp in lst:
                    if 'ql' in temp.lower():
                        name = temp
                        break
                    else:
                        name = lst[-3].strip()
                        break
            except Exception, e:
                LOGGER.info(" hba model not found" + str(e))

            for temp in lst:
                if 'fw' in temp.lower():
                    fwversion = temp[3:].strip()
                    if 'v' == fwversion[0].lower():
                        fwversion = fwversion[1:]
                    continue
                elif 'dv' in temp.lower():
                    driversion = re.split(':', temp)[-1][1:]
                    if '"' == driversion[-1]:
                        driversion = driversion[0:-1]

            newwwpn_line_lst = allhbaline_lst[idx:idx + 3]
            for newwwpn in newwwpn_line_lst:
                if ("Permanent".lower() in newwwpn.lower()) and ("port" in newwwpn.lower()) and ("name" in newwwpn.lower()):
                    wwpnnew = ""
                    wwpnnew = re.split('\s', newwwpn)[-1].strip()
                    newwwpn_lst.append(wwpnnew)
                    break
            if wwpnnew :
                qhbaobj.setModelName(name)
                qhbaobj.setDvVersion(driversion)
                qhbaobj.setFwVersion(fwversion)
                qhbaobj.setWwpn(wwpnnew)
            newhbaobj_lst.append(qhbaobj)

    objlstlst = []

    objlstlst.append(newhbaobj_lst)
    result = get_formatresult(objlstlst)

    context['result']=result
    return context



def isECard(line):
    '''
    @summary: 判断是否是E卡回文
    E卡： NodeSymb: [51] "Emulex 42D0494 FV1.11A5  DV2.74.214.004 VEEAMBACKUP"
    @param line: E卡回文段
    @return: True:是E卡 False:不是E卡 
    
    '''
    if ("emulex" in line.lower()) and ("NodeSymb" in line):
        return True
    else:
        return False


def isQCard(line):
    '''
    Q卡回文： NodeSymb: [33] "QLE2672 FW:v7.03.00 DVR:v2.1.30.0"
           规则:以空格分割取得数组。data[1]以FW:v开头，且data[2] DVR:v 开头，则是Q卡
          以空格分割取得数组。data[0] = Emulex 是E卡
    '''
    lst = re.split('\s', line)
    if (len(lst) < 3):
        return False

    if (lst[-1].lower().startswith('dvr')) and (lst[-2].lower().startswith('fw:v')):
        return True
    else:
        return False



def get_formatresult(allnamedvfw_objs_lst):
    result = ""
    allnamedvfw_objslst = []
    for objlst in allnamedvfw_objs_lst:
        for obj in objlst:
            allnamedvfw_objslst.append(obj)
    for namewwpn in allnamedvfw_objslst:
        wwpnTemp = ' ' if namewwpn.get_wwpn() == '' else namewwpn.get_wwpn()
        result = result + wwpnTemp
        result = result + ','
    result = result[0:-1]
    result = result + ';'

    for namedvfw in allnamedvfw_objslst:
        nameTemp = ' ' if namedvfw.get_name() == '' else namedvfw.get_name()
        result = result + nameTemp
        result = result + ','
    result = result[0:-1]
    result = result + ';'

    for namedvfw in allnamedvfw_objslst:
        versionTemp = ' ' if namedvfw.get_version() == '' else namedvfw.get_version()
        result = result + versionTemp
        result = result + ','
    result = result[0:-1]
    result = result + ';'

    for namedvfw in allnamedvfw_objslst:
        firmwareTemp = ' ' if namedvfw.get_fwversion() == '' else namedvfw.get_fwversion()
        result = result + firmwareTemp
        result = result + ','
    result = result[0:-1]
    return result

class Name_Dv_FW:
    __modelName = 'NA'
    __driverVersion = 'NA'
    __fwVersion = 'NA'
    __dvwwpn = 'NA'

    def setModelName(self, name):
        self.__modelName = name
    def setDvVersion(self, version):
        self.__driverVersion = version
    def setFwVersion(self, fwversion):
        self.__fwVersion = fwversion
    def setWwpn(self, wwpn):
        self.__dvwwpn = wwpn


    def get_name(self):
        return self.__modelName
    def get_version(self):
        return self.__driverVersion
    def get_fwversion(self):
        return self.__fwVersion
    def get_wwpn(self):
        return self.__dvwwpn


#获取报告中所有的wwpn放到list中
def get_hba_wwpn(context, comdlst):
    allhbawwpn_lst = []
    wwnlst_lst = getSameCommandsHbaRetFromTxt(context, comdlst)
    for wwnlst in wwnlst_lst:
        allhbawwpn_lst.append(get_single_hbawwpn(wwnlst))
    return allhbawwpn_lst
#获取单条命令的回文之wwpn信息        
def get_single_hbawwpn(single_lst):
    wwnlst = []
    single_lst = check_lst(single_lst)
    for line in single_lst:
        if ('Permanent' in line) and ('Port' in line) and ('Name' in line)and ('-i' not in line):
            wwnlst.append(re.split('\s', line)[-1].strip())
    return wwnlst

