# --*-- coding:utf-8 --*--

divide = "*********^^^^^^^^^^************^^^^^^^^^^*********"
fileList = None
command = None
SWITCH_TYPE_DICT = {
                    "1":"Brocade 1000 Switches",
                    "2":"Brocade 2800 Switch",
                    "3":"Brocade 2100/2400 Switches",
                    "4":"Brocade 20x0 Switches",
                    "5":"Brocade 22x0 Switches",
                    "6":"Brocade 2800 Switch",
                    "7":"Brocade 2000 Switch",
                    "9":"Brocade 3800 Switch",
                    "10":"Brocade 12000 Director",
                    "12":"Brocade 3900 Switch",
                    "16":"Brocade 3200 Switch",
                    "17":"Brocade 3800VL",
                    "18":"Brocade 3000 Switch",
                    "21":"Brocade 24000 Director",
                    "22":"Brocade 3016 Switch",
                    "26":"Brocade 3850 Switch",
                    "27":"Brocade 3250 Switch",
                    "29":"Brocade 4012 Embedded Switch",
                    "32":"Brocade 4100 Switch",
                    "33":"Brocade 3014 Switch",
                    "34":"Brocade 200E Switch",
                    "37":"Brocade 4020 Embedded Switch",
                    "38":"Brocade 7420 Switch",
                    "40":"Brocade FCR Front Domain",
                    "41":"Brocade FCR Xlate Domain",
                    "42":"Brocade 48000 Director",
                    "43":"Brocade 4024 Embedded Switch",
                    "44":"Brocade 4900 Switch",
                    "45":"Brocade 4016 Embedded Switch",
                    "46":"Brocade 7500 Switch",
                    "51":"Brocade 4018 Embedded Switch",
                    "55":"Brocade 7600 Switch",
                    "58":"Brocade 5000 Switch",
                    "61":"Brocade 4424 Embedded Switch",
                    "62":"Brocade DCX Backbone",
                    "64":"Brocade 5300 Switch",
                    "66":"Brocade 5100 Switch",
                    "67":"Brocade Encryption Switch",
                    "69":"Brocade 5410 Switch",
                    "70":"Brocade 5410 Embedded Switch",
                    "71":"Brocade 300 Switch",
                    "72":"Brocade 5480 Embedded Switch",
                    "73":"Brocade 5470 Embedded Switch",
                    "75":"Brocade M5424 Embedded Switch",
                    "76":"Brocade 8000 Switch",
                    "77":"Brocade DCX-4S Switch",
                    "83":"Brocade 7800 Extension Switch",
                    "86":"Brocade 5450 Embedded Switch",
                    "87":"Brocade 5460 Embedded Switch",
                    "90":"Brocade 8470 Embedded Switch",
                    "92":"Brocade VA-40FC Switch",
                    "95":"Brocade VDX 6720-24 DC Switch",
                    "96":"Brocade VDX 6730-32 DC Switch",
                    "97":"Brocade VDX 6720-60 DC Switch",
                    "98":"Brocade VDX 6730-76 DC Switch",
                    "108":"Dell M8428-k FCoE Embedded Switch",
                    "109":"Brocade 6510 Switch",
                    "116":"Brocade VDX 6710 DC Switch",
                    "117":"Brocade 6547 Embedded Switch",
                    "118":"Brocade 6505 Switch",
                    "120":"Brocade DCX 8510-8 Backbone",
                    "121":"Brocade DCX 8510-4 Backbone",
                    
                    
                    #2017/06/28新加的
                    "109":"Brocade 6510",
                    "118":"Brocade 6505",
                    "120":"Brocade DCX 8510-8",
                    "121":"Brocade DCX 8510-4",
                    
                    "133":"Brocade 6520",
                    
                    "170":"Brocade G610",
                    "166":"Brocade X6-8",
                    "165":"Brocade X6-4",
                    "162":"Brocade G620"
                    
}


#获取主机名
def execute(context):
    global fileList
    global command
    firstSpaceIndex=None
    firstNumIndex=None
    pathstr=None
    cpu_nums=0
    
    command = context.get("command")
    pathstr = context.get("path")
    
    fileList=getTxtReportList(pathstr);
    dict = getCommandStartEndIndex(command)
    startIndex = dict["start"]
    endIndex = dict["end"]
    tempList = fileList[startIndex:endIndex + 1]
    context["result"]=extractInfo(tempList)
    return context
    
def extractInfo(callList):
    callvalue = ""
    for call in callList :
        if not(":" in call) :
            continue
        callArr = call.split(":")
        if len(callArr) < 2 :
            continue
        if "switchType" == callArr[0].strip() :
            callvalue = callArr[1].strip()
    if 0 == len(callvalue) :
        return ""
    switchType = SWITCH_TYPE_DICT.get(callvalue.split(".")[0], "")
    if 0 == len(switchType) :
        return ""
        
    return switchType

#获取设备型号:Linux
def getEquipType():
    osList=getTxtReportList()
    osList=osList[2:3]
    osName=osList[0]
    return "Linux"
    
#获取Txt报告列表
def getTxtReportList(pathStr):
    fileHandle = open(pathStr, 'r');
    listtemp = fileHandle.readlines()
    fileHandle.close()
    return listtemp
    

#获取某命令的开始和结束索引
def getCommandStartEndIndex(command):
    start = 0
    end = 0
    for i in range(len(fileList)):
        if command.strip().lower() in fileList[i].strip().lower():
            start = i + 2
    for j in range(start, len(fileList)):
        if divide.strip().lower() in fileList[j].strip().lower():
            end = j - 1
            break
    return {"start":start, "end":end}     