# --*-- coding:utf-8 --*--
import sys
import os
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import *

def execute(context):
    global LOG
    LOG = context.get("Logger")
    WWPN_COMD = "cmd_display_cisco_hba_wwpn"
    NAMEFWDV_COMD = "cmd_display_cisco_hba_namedrifw"
    
    wwpn_comd_lst = get_hba_wwpn(context,[WWPN_COMD])
    namefwdv_objlst = get_namedvfw_objs(context,[NAMEFWDV_COMD])
    
    result = get_formatresult(wwpn_comd_lst,namefwdv_objlst)
    
    context["result"]=result
    
    return context

def get_formatresult(wwpnlst,allnamedvfw_objs_lst):
    result = ""
    cleaned_wwpnlst = [] 
    
    allnamedvfw_objslst = allnamedvfw_objs_lst
    
    for obj in allnamedvfw_objslst:
        index = obj.get_valueIndex()
        cleaned_wwpnlst.append(wwpnlst[0][index])
    
    
    for wwpn in cleaned_wwpnlst:
            wwpnTemp = ' ' if wwpn == '' else wwpn
            result = result + wwpnTemp + ','
    result = result[0:-1]
    result = result + ';'
    
    for namedvfw in allnamedvfw_objslst:
        nameTemp = ' ' if namedvfw.get_name() == '' else namedvfw.get_name()
        result = result + nameTemp
        result = result + ','
    result = result[0:-1]
    result = result + ';'
    
    for namedvfw in allnamedvfw_objslst:
        versionTemp=' ' if namedvfw.get_version()=='' else namedvfw.get_version()
        result = result + versionTemp
        result = result + ','
    result = result[0:-1]
    result = result + ';'
    
    for namedvfw in allnamedvfw_objslst:
        firmwareTemp = ' ' if namedvfw.get_fwversion() == '' else namedvfw.get_fwversion()
        result = result + firmwareTemp
        result = result + ','
    result = result[0:-1]
    
    return result


#MDS9148S# show fcns database detail | grep -i "symbolic-node-name"
#symbolic-node-name          :QLE2560 FW:v8.02.00 DVR:v2.1.53.0
#symbolic-node-name          :QLE2672 FW:v6.02.00 DVR:v2.1.53.0
#symbolic-node-name      :Emulex LPe1250-F8 FV2.01A13 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0
#symbolic-node-name          :

def get_namedvfw_objs(context,comdlst):
    obj_lst = []
    lines = []
    value_lines = []
    
    try:
        lines = getSameCommandsHbaRetFromTxt(context, comdlst)[0]
    except:
        LOG.error("out of index:" + unicode(traceback.format_exc()))
    #找到含有hba卡型号、驱动版本、fw版本的行
    for line in lines:
        if ('symbolic-node-name' in line.lower()) and ('-i' not in line.lower()):
            value_lines.append(line)

    for idx, hbaline in enumerate(value_lines):
        temp = hbaline.replace('symbolic-node-name', '').strip()
        #如果只有':'则hba卡没有值
        if (':' != temp.strip()):
            hbaobj = Name_Dv_FW()
            hbaobj.setValueIndex(idx)
            hbaatom_lst = re.split('\s+',temp)
            #E卡
            if isECard(hbaline):
                values = re.split('\s',temp)
                for hba in values:
                    try:
                        if 'lpe' in hba.lower():
                            hbaobj.setModelName(hba)
                            continue
                        else:
                            hbaobj.setModelName(hbaatom_lst[1].strip())
                    except:
                        LOG.error("Emulex hba model not found:" + unicode(traceback.format_exc()))

                    try:
                        if hba.lower().startswith('fv'):
                            hbaobj.setFwVersion(hba[2:].strip())
                            continue
                    except:
                        LOG.error("Emulex hba fwversion not found:" + unicode(traceback.format_exc()))

                    try:
                        if hba.lower().startswith('dv'):
                            drVersion = hba[2:].strip()
                            if '.' == drVersion[-1]:
                                drVersion = drVersion[0:-1]
                                hbaobj.setDvVersion(drVersion)
                            else:
                                hbaobj.setDvVersion(drVersion)
                    except:
                        LOG.error("Emulex driver version not found:" + unicode(traceback.format_exc()))
                        

            #Q卡
            elif isQCard(hbaline):
                values = re.split('\s', temp)
                try:
                    hbaobj.setModelName(values[0][1:])
                except:
                    LOG.error("hba model not found:" + unicode(traceback.format_exc()))

                for hba in values:
                    if 'fw' in hba.lower():
                        try:
                            fwversion = hba[3:].strip()
                            if 'v' == fwversion[0].strip().lower():
                                fwversion = fwversion[1:]
                            hbaobj.setFwVersion(fwversion)
                        except:
                            LOG.error("fw version not found:" + unicode(traceback.format_exc()))
                            
                    elif 'dvr' in hba.lower():
                        try:
                            dversion = hba[4:].strip()
                            if 'v' == dversion[0].strip().lower():
                                dversion = dversion[1:]
                            hbaobj.setDvVersion(dversion)
                        except:
                            LOG.error("driver version not found:" + unicode(traceback.format_exc()))
            if('NA' != hbaobj.get_name()):
                obj_lst.append(hbaobj)
    return obj_lst


def isECard(line):
    '''
    @summary: 判断是否是E卡回文
    E卡：symbolic-node-name          :Emulex LPe11002 FV2.71X15 DV8.2.0.128.3p
    @param line: E卡回文段
    @return: True:是E卡 False:不是E卡 
    
    '''
    lst = re.split('\s', line)
    if ('dv' not in line.lower()) or ('fv' not in line.lower()):
        return False

    if(len(lst) < 3):
        return False

    if ("emulex" in line.lower() and (lst[-1].lower().startswith('dv'))  and (lst[-2].lower().startswith('fv')))  :
        return True
    elif ("emulex" in line.lower() and "dv" in line.lower() and "fv" in line.lower()):
        return True
    else:
        return False


def isQCard(line):
    '''
    @summary: 判断是否是Q卡的回文
    @param line: Q卡回文行
    @return True:是Q卡回文 ；False：不是Q卡回文 
    Q卡回文：symbolic-node-name          :QLE2462 FW:v5.03.01 DVR:v8.03.01.12.10.3-k
           规则:以空格分割取得数组。data[1]以FW:v开头，且data[2] DVR:v 开头，则是Q卡
          异常回文1：symbolic-node-name          :
           异常回文2：symbolic-node-name          ::qlc0
          以空格分割取得数组。data[0] = Emulex 是E卡
    '''

    lst = re.split('\s', line)
    if('dvr' not in line.lower()) or ('fw:v' not in line.lower()):
        return False

    if (len(lst) < 3):
        return False

    if (lst[-1].lower().startswith('dvr')) and (lst[-2].lower().startswith('fw:v')):
        return True
    else:
        return False

class Name_Dv_FW:
    __valueIndex = 0
    __modelName = 'NA'
    __driverVersion = 'NA'
    __fwVersion = 'NA'

    def setModelName(self, name):
        self.__modelName = name
    def setDvVersion(self, version):
        self.__driverVersion = version
    def setFwVersion(self, fwversion):
        self.__fwVersion = fwversion
    def setValueIndex(self, idx):
        self.__valueIndex = idx


    def get_name(self):
        return self.__modelName
    def get_version(self):
        return self.__driverVersion
    def get_fwversion(self):
        return self.__fwVersion
    def get_valueIndex(self):
        return self.__valueIndex



#获取报告中所有的wwpn放到list中
def get_hba_wwpn(context,comdlst):
    allhbawwpn_lst = []
    wwnlst_lst = getSameCommandsHbaRetFromTxt(context,comdlst)
    for wwnlst in wwnlst_lst:
        allhbawwpn_lst.append(get_single_hbawwpn(wwnlst))
    return allhbawwpn_lst


#获取单条命令的回文之wwpn信息
#CTU1000032191:~ # show fcns database detail | grep -i "permanent-port-wwn (vendor)"
#permanent-port-wwn (vendor) :21:00:00:24:ff:05:f6:31             
#permanent-port-wwn (vendor) :21:00:00:0e:1e:09:a5:0b (Qlogic)    
#permanent-port-wwn (vendor) :10:00:00:00:c9:88:79:1f (Emulex)     
#permanent-port-wwn (vendor) :22:13:9c:37:f4:96:bd:b8            
def get_single_hbawwpn(single_lst):
    wwnlst = []
    single_lst = check_lst(single_lst)
    for line in single_lst:
        if ('permanent' in line.lower()) and ('port' in line.lower()) and ('wwn' in line.lower())and ('-i' not in line):
            if '('  in re.split('\s',line)[-1].strip():
                wwnlst.append(re.split('\s',line)[-2].strip()[1:])
            else:
                wwnlst.append(re.split('\s',line)[-1].strip()[1:])
    return wwnlst

