/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secas.framework;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AppContext {
    private static final ConcurrentHashMap<String, Object> TABLE = new ConcurrentHashMap();
    private static AppContext instance = new AppContext();
    private static final String APP_HOME_PATH = "beetle.application.home.path";

    private AppContext() {
    }

    public void setAppHomePath(String homePath) {
        this.bind(APP_HOME_PATH, homePath);
    }

    public String getAppHome() {
        String appHome = null;
        String fp = System.getProperty(APP_HOME_PATH);
        if (fp != null && !fp.trim().isEmpty()) {
            appHome = this.normalizePath(fp);
        } else {
            String ap = (String)AppContext.getInstance().lookup(APP_HOME_PATH);
            if (ap != null && !ap.trim().isEmpty()) {
                appHome = this.normalizePath(ap);
            }
        }
        if (null != appHome) {
            return appHome;
        }
        return "config/";
    }

    public void bind(String name, Object obj) {
        TABLE.put(name, obj);
    }

    public void close() {
        if (!TABLE.isEmpty()) {
            TABLE.clear();
        }
    }

    public Map<String, Object> getEnvironment() {
        return TABLE;
    }

    public Object lookup(String name) {
        return TABLE.get(name);
    }

    public void unbind(String name) {
        if (TABLE.containsKey(name)) {
            TABLE.remove(name);
        }
    }

    public static AppContext getInstance() {
        return instance;
    }

    private String normalizePath(String path) {
        String actualPath = path;
        if (null == actualPath || actualPath.trim().isEmpty()) {
            return null;
        }
        if (this.isURI(actualPath)) {
            if (!actualPath.endsWith("/")) {
                actualPath = actualPath + "/";
            }
            return actualPath;
        }
        try {
            actualPath = new File(actualPath).getCanonicalPath();
            if (!actualPath.endsWith("/")) {
                actualPath = actualPath + "/";
            }
            return actualPath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isURI(String path) {
        try {
            URI uri = new URI(path);
            return null != uri.getScheme();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

