/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secas.framework;

import com.huawei.secas.framework.AppContext;
import com.huawei.secas.framework.AppRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppProperties.class);
    private static Properties appPpt = new Properties();
    private static String path = null;

    private static void load() {
        InputStream in = AppProperties.searchProp();
        if (null == in) {
            return;
        }
        try {
            appPpt.load(in);
        }
        catch (IOException e) {
            throw new AppRuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                AppProperties.nop();
            }
        }
    }

    public static void reload() {
        appPpt.clear();
        AppProperties.load();
    }

    public static void clear() {
        appPpt.clear();
    }

    public static int getAsInt(String key) {
        String value = AppProperties.get(key);
        if (null == value || value.isEmpty()) {
            throw new AppRuntimeException("null or empty value, key = " + key);
        }
        return Integer.parseInt(value.trim());
    }

    public static float getAsFloat(String key) {
        String value = AppProperties.get(key);
        if (null == value || value.isEmpty()) {
            throw new AppRuntimeException("null or empty value, key = " + key);
        }
        return Float.parseFloat(value.trim());
    }

    public static float getAsFloat(String key, float defaultValue) {
        String value = AppProperties.get(key);
        if (null == value || value.isEmpty()) {
            return defaultValue;
        }
        return Float.parseFloat(value.trim());
    }

    public static int getAsInt(String key, int defaultValue) {
        String a = AppProperties.get(key);
        if (a == null || a.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(a.trim());
    }

    public static Properties getProperties() {
        return appPpt;
    }

    private static String get(String key) {
        return appPpt.getProperty(key);
    }

    public static String getByDecode(String key, String charsetName) throws UnsupportedEncodingException {
        String x = AppProperties.get(key);
        if (x == null) {
            return null;
        }
        String xx = new String(x.getBytes(charsetName), Charset.defaultCharset());
        return xx;
    }

    public static String get(String key, String defaultValue) {
        String a = AppProperties.get(key);
        if (a == null) {
            return defaultValue;
        }
        return a;
    }

    public static boolean getAsBoolean(String key) {
        String value = AppProperties.get(key);
        if (null == value || value.isEmpty()) {
            throw new AppRuntimeException("null or empty value, key = " + key);
        }
        return Boolean.parseBoolean(value.trim());
    }

    public static boolean getAsBoolean(String key, boolean defaultValue) {
        String a = AppProperties.get(key);
        if (a == null || a.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(a.trim());
    }

    public static String getPath() {
        return path;
    }

    public static void setPath(String path) {
        AppProperties.path = path;
    }

    private static InputStream searchProp() {
        InputStream result = null;
        String fp = AppContext.getInstance().getAppHome();
        String filenamePath = fp.trim().length() > 0 ? fp + "application.properties" : "config/application.properties";
        File f = new File(filenamePath);
        if (f.exists()) {
            try {
                FileInputStream bis;
                result = bis = FileUtils.openInputStream((File)f);
                AppProperties.setPath(f.getCanonicalFile().getCanonicalPath());
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Exception: [application.properties] not found");
            }
            catch (Exception ex) {
                AppProperties.nop();
            }
        } else {
            try {
                URL url = AppProperties.getResAsURL(filenamePath);
                if (null == url) {
                    return null;
                }
                AppProperties.setPath(AppProperties.getPathFromUrl(url));
                result = url.openStream();
            }
            catch (IOException e) {
                AppProperties.nop();
            }
        }
        return result;
    }

    private static void nop() {
    }

    private static URL getResAsURL(String resource) throws IOException {
        return AppProperties.getResAsURL(Thread.currentThread().getContextClassLoader(), resource);
    }

    private static URL getResAsURL(ClassLoader loader, String resource) throws IOException {
        URL url;
        if (loader != null && null != (url = loader.getResource(resource))) {
            return url;
        }
        url = ClassLoader.getSystemResource(resource);
        if (null != url) {
            return url;
        }
        return new URL(resource);
    }

    private static String getPathFromUrl(URL url) throws IOException {
        if (null == url) {
            return null;
        }
        String protocol = url.getProtocol();
        if (null == protocol || protocol.isEmpty()) {
            return null;
        }
        if (protocol.equals("file")) {
            try {
                return new File(url.toURI()).getCanonicalFile().getCanonicalPath();
            }
            catch (URISyntaxException e) {
                AppProperties.nop();
            }
        } else if (protocol.equals("jndi")) {
            ServletContext servletContext = (ServletContext)AppContext.getInstance().lookup("web.app.servlet.context");
            if (null == servletContext) {
                return null;
            }
            String propPath = (String)AppContext.getInstance().lookup("web.app.config.home.path");
            if (null == propPath) {
                return null;
            }
            propPath = propPath + "/application.properties";
            String context = servletContext.getContextPath();
            if (null != context && !context.isEmpty()) {
                int first = propPath.indexOf(47);
                int second = propPath.indexOf(47, first + 1);
                int third = propPath.indexOf(47, second + 1);
                propPath = propPath.substring(third);
            } else {
                int first = propPath.indexOf(47);
                int second = propPath.indexOf(47, first + 1);
                propPath = propPath.substring(second);
            }
            return servletContext.getRealPath(propPath);
        }
        return null;
    }

    static {
        AppProperties.load();
    }
}

