/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secas.kmc;

import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.KdfAlgForPwd;
import com.huawei.kmc.crypt.CryptoAPIEx;
import com.huawei.secas.framework.AppContext;
import com.huawei.secas.framework.AppRuntimeException;
import com.huawei.secas.kmc.KmcInitialize;
import com.huawei.secas.kmc.Util;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptUtil.class);

    public EncryptUtil() {
        String catalinaHome = Util.getCatalinaHome();
        AppContext.getInstance().setAppHomePath(catalinaHome + "/conf/keystore/");
    }

    public static String encrypt(String ksPass) throws AppException {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null.");
            throw new AppRuntimeException("kmcIni is null.");
        }
        if (ksPass == null) {
            LOGGER.error("contextPlain is null.");
            throw new AppRuntimeException("cipherText is null.");
        }
        return kmcIni.encrypt(ksPass);
    }

    public static String decrypt(String eKsPass) throws AppException {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null.");
            throw new AppRuntimeException("kmcIni is null.");
        }
        if (eKsPass == null) {
            LOGGER.error("cipherText is null.");
            throw new AppRuntimeException("cipherText is null.");
        }
        return kmcIni.decrypt(eKsPass);
    }

    public static String encryptByFactoryKey(String plaintText, boolean isChinese) throws AppException {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null when encryptByFactoryKey.");
            throw new AppRuntimeException("kmcIni is null when encryptByFactoryKey.");
        }
        if (plaintText == null) {
            LOGGER.error("cipherText is null when encryptByFactoryKey.");
            throw new AppRuntimeException("cipherText is null when encryptByFactoryKey.");
        }
        return kmcIni.encryptByFactoryKey(plaintText, isChinese);
    }

    public static String hmac(int domainId, String plainText) throws AppException {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null.");
            throw new AppRuntimeException("kmcIni is null.");
        }
        if (plainText == null || plainText.isEmpty()) {
            LOGGER.error("cipherText is null or empty.");
            throw new AppRuntimeException("cipherText is null or empty.");
        }
        CryptoAPIEx api = kmcIni.getSwApi();
        return new String(api.hmac(domainId, plainText.getBytes(StandardCharsets.UTF_8)));
    }

    public static boolean hmacVerify(int domainId, String plainText, String hmacData) throws AppException {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null. hmacVerify fail.");
            throw new AppRuntimeException("kmcIni is null. hmacVerify fail.");
        }
        CryptoAPIEx api = kmcIni.getSwApi();
        return api.hmacVerify(domainId, plainText.getBytes(StandardCharsets.UTF_8), hmacData.getBytes(StandardCharsets.UTF_8));
    }

    public static String protectPwdEx(KdfAlgForPwd algForPwd, int iter, String pwd) throws AppException {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null. hmacVerify fail.");
            throw new AppRuntimeException("kmcIni is null. hmacVerify fail.");
        }
        CryptoAPIEx api = kmcIni.getSwApi();
        return new String(api.protectPwdEx(algForPwd, iter, pwd.getBytes(StandardCharsets.UTF_8)));
    }

    public static boolean verifyPwdEx(String pwd, String protectPwd) throws AppException {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null. hmacVerify fail.");
            throw new AppRuntimeException("kmcIni is null. hmacVerify fail.");
        }
        CryptoAPIEx api = kmcIni.getSwApi();
        return api.verifyPwdEx(StringUtils.defaultString((String)pwd).getBytes(StandardCharsets.UTF_8), StringUtils.defaultString((String)protectPwd).getBytes(StandardCharsets.UTF_8));
    }

    public static void updateRootKey() throws AppException {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null. updateRootKey fail.");
            throw new AppRuntimeException("kmcIni is null. updateRootKey fail.");
        }
        CryptoAPIEx api = kmcIni.getSwApi();
        api.updateRootKey();
        LOGGER.info("updateRootKey successfully.");
    }

    public static boolean refreshMkMask() {
        KmcInitialize kmcIni = KmcInitialize.getInstance();
        if (kmcIni == null) {
            LOGGER.error("kmcIni is null. refreshMkMask fail.");
            return false;
        }
        LOGGER.info("refreshMkMask start.");
        return kmcIni.refreshMkMask();
    }
}

