/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secas.kmc;

import com.huawei.kmc.common.AppException;
import com.huawei.secas.framework.AppContext;
import com.huawei.secas.framework.AppRuntimeException;
import com.huawei.secas.kmc.EncryptUtil;
import com.huawei.secas.kmc.Util;
import java.io.Console;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KSPass {
    private static final int CMD_ARGS_LEN_MIN = 1;
    private static final int CMD_ARGS_NAME_INDEX = 0;
    private static final int CMD_ARGS_ACTION_INDEX = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(KSPass.class);

    public KSPass() {
        String catalinaHome = Util.getCatalinaHome();
        AppContext.getInstance().setAppHomePath(catalinaHome + "/webapps/ROOT/WEB-INF/classes/");
    }

    public String encrypt(String ksPass) throws AppException {
        return EncryptUtil.encrypt(ksPass);
    }

    public String decrypt(String eKsPass) throws AppException {
        return EncryptUtil.decrypt(eKsPass);
    }

    public void updateRootKey() throws AppException {
        EncryptUtil.updateRootKey();
    }

    public static void main(String[] args) {
        if (1 >= args.length) {
            KSPass.usage();
            return;
        }
        String userName = args[0];
        if (null == userName || userName.isEmpty() || !userName.equals(System.getProperty("user.name"))) {
            System.out.println("Error: user name error.");
            LOGGER.error("KSPass Error: user name error [" + userName + "/" + System.getProperty("user.name") + "]");
            return;
        }
        KSPass ksPass = new KSPass();
        String action = args[1];
        if (action.equalsIgnoreCase("-encrypt")) {
            KSPass.encryptFun(args, userName, ksPass);
        } else if (action.equalsIgnoreCase("-updateRootKey")) {
            try {
                ksPass.updateRootKey();
                System.out.println("update Root Key Successfully.");
            }
            catch (AppException e) {
                System.out.println("updateRootKey fail.");
                throw new AppRuntimeException(e);
            }
        } else {
            KSPass.usage();
        }
    }

    private static void encryptFun(String[] args, String userName, KSPass ksPass) {
        String cipherPass;
        String plainPass;
        if (2 == args.length) {
            Console in = System.console();
            if (null == in) {
                throw new AppRuntimeException("Console is Not Available");
            }
            char[] pass = in.readPassword("Please Input keystorePass/truststorePass: ", new Object[0]);
            if (null == pass) {
                throw new AppRuntimeException("Input Passwd Invalid: null");
            }
            plainPass = String.valueOf(pass);
        } else {
            plainPass = args[2];
        }
        if (null == plainPass || plainPass.isEmpty()) {
            KSPass.usage();
            return;
        }
        try {
            cipherPass = ksPass.encrypt(plainPass);
        }
        catch (AppException e) {
            System.out.println("encrypt fail.");
            throw new AppRuntimeException(e);
        }
        System.out.println();
        System.out.println("Please Copy the value to Connector/keystorePass or truststorePass:");
        System.out.println(cipherPass);
        System.out.println();
        LOGGER.info("user [ {} ] encrypt pass. Success", (Object)userName);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("Encrypt keystorePass/truststorePass:");
        System.out.println("\t\tkspass -encrypt [plain text of keystorePass/truststorePass]");
        System.out.println("Update current root key manually:");
        System.out.println("\t\tkspass -updateRootKey");
    }
}

