/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secas.kmc;

import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.IHardwareCallback;
import com.huawei.kmc.common.ILogger;
import com.huawei.kmc.common.INotifyCallback;
import com.huawei.kmc.common.InitStage;
import com.huawei.kmc.crypt.CryptoAPIEx;
import com.huawei.secas.framework.AppProperties;
import com.huawei.secas.framework.AppRuntimeException;
import com.huawei.secas.kmc.KmcLogger;
import com.huawei.secas.kmc.KmcNotifyCallback;
import com.huawei.secas.kmc.Util;
import com.huawei.secas.kmc.kmshardware.KmsAddrModel;
import com.huawei.secas.kmc.kmshardware.KmsHardwareCallback;
import com.huawei.secas.kmc.kmshardware.KmsUserModel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmcInitialize {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)KmcInitialize.class.getName());
    private static final String SW_PRIMARY_KEY_STORE_FILE = "/kp";
    private static final String SW_STANDBY_KEY_STORE_FILE = "/ks";
    private static final String HW_PRIMARY_KEY_STORE_FILE = "/hwkp";
    private static final String HW_STANDBY_KEY_STORE_FILE = "/hwks";
    private static final String SW_PRIMARY_KEY_STORE_FILE_KEY = "primary_key_store_file";
    private static final String SW_STANDBY_KEY_STORE_FILE_KEY = "standby_key_store_file";
    private static final String HW_PRIMARY_KEY_STORE_FILE_KEY = "hw_primary_key_store_file";
    private static final String HW_STANDBY_KEY_STORE_FILE_KEY = "hw_standby_key_store_file";
    private static final String KMS_AK_KEY = "kms_ak";
    private static final String KMS_SK_KEY = "kms_sk";
    private static final String KMS_PROJECT_ID_KEY = "kms_project_id";
    private static final String KMS_ENDPOINT_KEY = "kms_endpoint";
    private static final String DOMAIN_COUNT = "2";
    private static final String AUTO_UPDATE_MK_ENABLED = "true";
    private static final String AUTO_UPDATE_MK_DISABLED = "false";
    private static final String CRYPT_PROC_SEM_KEY = "1386";
    private static final String CRYPT_KEY_LIFETIME_DAYS = "180";
    private static final String KS_CONF_PATH = "conf/ksPath";
    private static final String CRYPTOGRAPHIC_ALGORITHM_KEY = "cryptographicAlgorithm";
    private static final String ENCRYPT_TEXT_SPLIT_FLAG = ";";
    private static KmcInitialize instance = null;
    private static CryptoAPIEx swApi = new CryptoAPIEx();
    private static CryptoAPIEx hwApi = new CryptoAPIEx();
    private static final CryptoAPIEx swApi4FactoryKey = new CryptoAPIEx();
    static final ILogger KMCLOGGER = new KmcLogger();

    public static synchronized KmcInitialize getInstance() {
        if (instance == null) {
            int stage = swApi.getInitStage();
            LOGGER.info("software api stage:{}", (Object)stage);
            if (stage == InitStage.UNINIT.getValue()) {
                LOGGER.error("software api CryptoAPI getInstance failed, maybe JNI library not load check your env status.");
            }
            stage = hwApi.getInitStage();
            LOGGER.info("hardware api stage:{}", (Object)stage);
            if (stage == InitStage.UNINIT.getValue()) {
                LOGGER.error("software api CryptoAPI getInstance failed, maybe JNI library not load check your env status.");
            }
            instance = new KmcInitialize();
        }
        return instance;
    }

    private KmcInitialize() {
        this.register4Kmc();
        if (!this.initializeKmc()) {
            LOGGER.warn("initializeKmcHW fail.");
        }
    }

    public boolean initializeKmc() {
        File ksPath = this.getKsPath(KS_CONF_PATH);
        if (ksPath == null) {
            LOGGER.error("getKsPath failed when getKsPath.");
            throw new AppRuntimeException("getKsPath failed when getKsPath.");
        }
        Properties commonAppConfig = this.getCommonProperties();
        boolean result = this.initializeKmc4Sw(ksPath, commonAppConfig);
        if (!result) {
            throw new AppRuntimeException("initializeKmc4Sw fail.");
        }
        return this.initializeKmc4Hw(ksPath, commonAppConfig);
    }

    public boolean initializeKmc4Hw() {
        if (hwApi.getInitStage() == InitStage.INIT_KMC_DONE.getValue()) {
            return true;
        }
        File ksPath = this.getKsPath(KS_CONF_PATH);
        if (ksPath == null) {
            LOGGER.error("getKsPath failed when getKsPath.");
            throw new AppRuntimeException("getKsPath failed when getKsPath.");
        }
        Properties commonAppConfig = this.getCommonProperties();
        return this.initializeKmc4Hw(ksPath, commonAppConfig);
    }

    private boolean initializeKmc4Hw(File ksPath, Properties commonAppConfig) {
        boolean isChinese = BooleanUtils.toBoolean((int)AppProperties.getAsInt(CRYPTOGRAPHIC_ALGORITHM_KEY, 0));
        if (!isChinese) {
            LOGGER.warn("Crypt Algorithm is not chinese, no need to init hw.");
            return true;
        }
        Properties hwAppConfig = (Properties)commonAppConfig.clone();
        try {
            String path = ksPath.getCanonicalPath();
            String hwPrimaryKeyStoreFile = path + AppProperties.get(HW_PRIMARY_KEY_STORE_FILE_KEY, HW_PRIMARY_KEY_STORE_FILE);
            String hwStandbyKeyStoreFile = path + AppProperties.get(HW_STANDBY_KEY_STORE_FILE_KEY, HW_STANDBY_KEY_STORE_FILE);
            hwAppConfig.setProperty(SW_PRIMARY_KEY_STORE_FILE_KEY, hwPrimaryKeyStoreFile);
            hwAppConfig.setProperty(SW_STANDBY_KEY_STORE_FILE_KEY, hwStandbyKeyStoreFile);
            hwAppConfig.put("enableHw", "1");
            hwApi.setHardCallBack(this.buildHardwareCallback());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UnsupportedEncodingException:", (Throwable)e);
            return false;
        }
        catch (AppException e) {
            LOGGER.error("AppException:", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOGGER.error("get canonical path fail: {}", (Object)ksPath, (Object)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Exception:", (Throwable)e);
            return false;
        }
        return this.initializeKmcFun(hwApi, hwAppConfig);
    }

    private boolean initializeKmc4Sw(File ksPath, Properties commonAppConfig) {
        String path;
        try {
            path = ksPath.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get canonical path fail: {}", (Object)ksPath, (Object)e);
            return false;
        }
        String swPrimaryKeyStoreFile = path + AppProperties.get(SW_PRIMARY_KEY_STORE_FILE_KEY, SW_PRIMARY_KEY_STORE_FILE);
        String swStandbyKeyStoreFile = path + AppProperties.get(SW_STANDBY_KEY_STORE_FILE_KEY, SW_STANDBY_KEY_STORE_FILE);
        Properties swAppConfig = (Properties)commonAppConfig.clone();
        swAppConfig.setProperty(SW_PRIMARY_KEY_STORE_FILE_KEY, swPrimaryKeyStoreFile);
        swAppConfig.setProperty(SW_STANDBY_KEY_STORE_FILE_KEY, swStandbyKeyStoreFile);
        return this.initializeKmcFun(swApi, swAppConfig);
    }

    private IHardwareCallback buildHardwareCallback() throws UnsupportedEncodingException, AppException {
        String ak = AppProperties.getByDecode(KMS_AK_KEY, StandardCharsets.UTF_8.name());
        if (StringUtils.isEmpty((CharSequence)ak)) {
            throw new AppRuntimeException("ak is empty.");
        }
        ak = this.decrypt(ak);
        String sk = AppProperties.getByDecode(KMS_SK_KEY, StandardCharsets.UTF_8.name());
        if (StringUtils.isEmpty((CharSequence)ak)) {
            throw new AppRuntimeException("sk is empty.");
        }
        sk = this.decrypt(sk);
        KmsUserModel userModel = new KmsUserModel();
        userModel.setAk(ak);
        userModel.setSk(sk);
        userModel.setProjectId(AppProperties.get(KMS_PROJECT_ID_KEY, ""));
        KmsAddrModel addrModel = new KmsAddrModel();
        addrModel.setEndPoint(AppProperties.get(KMS_ENDPOINT_KEY, ""));
        return new KmsHardwareCallback(userModel, addrModel);
    }

    private boolean initializeKmcFun(CryptoAPIEx api, Properties appConfig) {
        try {
            int stage = api.getInitStage();
            LOGGER.info("initializeKmcFun:CryptoAPI InitStage is {}.", (Object)stage);
            if (stage == InitStage.INIT_KMC_DONE.getValue()) {
                LOGGER.info("initializeKmcFun:software api stage is 2, finalized.");
                api.finalized();
            }
            api.initialize(appConfig);
        }
        catch (AppException exception) {
            LOGGER.error("initializeKmcFun fail, maybe already init, AppException:", (Throwable)exception);
            return false;
        }
        return true;
    }

    private void register4Kmc() {
        CryptoAPIEx.setJniLogger((ILogger)KMCLOGGER);
        CryptoAPIEx.setLogLevel((ILogger.LogLevel)ILogger.LogLevel.INFO);
        KmcNotifyCallback kmcNotifyCallBack = new KmcNotifyCallback();
        CryptoAPIEx.setJniNotifyCallback((INotifyCallback)kmcNotifyCallBack);
    }

    private Properties getCommonProperties() {
        AppProperties.reload();
        Properties appConfig = new Properties();
        appConfig.setProperty("domain_count", AppProperties.get("domain_count", DOMAIN_COUNT));
        appConfig.setProperty("auto_update_mk_enabled", AppProperties.get("auto_update_mk_enabled", AUTO_UPDATE_MK_ENABLED));
        appConfig.setProperty("crypt_proc_sem_key", AppProperties.get("crypt_proc_sem_key", CRYPT_PROC_SEM_KEY));
        appConfig.setProperty("crypt_key_lifetime_days", AppProperties.get("crypt_key_lifetime_days", CRYPT_KEY_LIFETIME_DAYS));
        boolean isChinese = BooleanUtils.toBoolean((int)AppProperties.getAsInt(CRYPTOGRAPHIC_ALGORITHM_KEY, 0));
        if (isChinese) {
            this.setAppConfig4Chinese(appConfig);
        }
        return appConfig;
    }

    private void setAppConfig4Chinese(Properties appConfig) {
        LOGGER.info("Chinese cryptographic algorithm is set.");
        appConfig.put("crypt_symmetric_algorithm", "SM4_CTR");
        appConfig.put("crypt_hamc_algorithm", "HMAC_SM3");
        appConfig.put("inner_crypt_symmetric_algorithm", "SM4_CTR");
        appConfig.put("inner_crypt_hmac_algorithm", "HMAC_SM3");
        appConfig.put("inner_crypt_hash_algorithm", "HASH_SM3");
        appConfig.put("inner_crypt_kdf_algorithm", "PBKDF2_HMAC_SM3");
    }

    private File getKsPath(String subPath) {
        String catalinaHome = Util.getCatalinaHome();
        String curPath = catalinaHome + subPath;
        File ksPath = new File(curPath);
        if (!ksPath.exists()) {
            LOGGER.error("ksPath is not exist.");
            return null;
        }
        return ksPath;
    }

    public CryptoAPIEx getSwApi() {
        return swApi;
    }

    public CryptoAPIEx getHwApi() {
        return hwApi;
    }

    public String encrypt(String plainText) {
        if (StringUtils.isEmpty((CharSequence)plainText)) {
            LOGGER.error("plainText is null or empty.");
            throw new AppRuntimeException("plainText is null or empty.");
        }
        String result = "";
        try {
            result = new String(hwApi.encrypt(plainText.getBytes(StandardCharsets.UTF_8)));
        }
        catch (AppException e) {
            LOGGER.error("hwApi encrypt AppException:", (Throwable)e);
        }
        result = result + ENCRYPT_TEXT_SPLIT_FLAG;
        try {
            result = result + new String(swApi.encrypt(plainText.getBytes(StandardCharsets.UTF_8)));
        }
        catch (AppException e) {
            LOGGER.error("swApi encrypt AppException:", (Throwable)e);
        }
        this.checkEncryptResult(result);
        return result;
    }

    private void checkEncryptResult(String result) {
        String[] cipherTexts = result.split(ENCRYPT_TEXT_SPLIT_FLAG);
        if (cipherTexts.length <= 0) {
            throw new AppRuntimeException("encrypt failed by both hw and sw, pls check.");
        }
    }

    public String decrypt(String cipherText) throws AppException {
        if (StringUtils.isEmpty((CharSequence)cipherText)) {
            LOGGER.error("cipherText is null or empty.");
            throw new AppRuntimeException("cipherText is null or empty.");
        }
        if (cipherText.contains(ENCRYPT_TEXT_SPLIT_FLAG)) {
            String[] cipherTexts = cipherText.split(ENCRYPT_TEXT_SPLIT_FLAG);
            if (cipherTexts.length <= 0) {
                throw new AppRuntimeException("cipherTexts is only flag of ;.");
            }
            if (cipherTexts.length == 1) {
                return new String(hwApi.decrypt(cipherTexts[0].getBytes(StandardCharsets.UTF_8)));
            }
            try {
                return new String(hwApi.decrypt(cipherTexts[0].getBytes(StandardCharsets.UTF_8)));
            }
            catch (AppException e) {
                LOGGER.error("hwApi decrypt AppException:", (Throwable)e);
                return new String(swApi.decrypt(cipherTexts[1].getBytes(StandardCharsets.UTF_8)));
            }
        }
        try {
            return new String(swApi.decrypt(cipherText.getBytes(StandardCharsets.UTF_8)));
        }
        catch (AppException e) {
            return new String(hwApi.decrypt(cipherText.getBytes(StandardCharsets.UTF_8)));
        }
    }

    public boolean refreshMkMask() {
        boolean result = true;
        try {
            swApi.refreshMkMask();
        }
        catch (AppException e) {
            LOGGER.error("swApi refreshMkMask exception:");
            result = false;
        }
        try {
            hwApi.refreshMkMask();
        }
        catch (AppException e) {
            LOGGER.error("hwApi refreshMkMask exception:");
            result = false;
        }
        return result;
    }

    public String encrypt(String plainText, boolean isSw) throws AppException {
        if (StringUtils.isEmpty((CharSequence)plainText)) {
            LOGGER.error("plainText is null or empty.");
            throw new AppRuntimeException("plainText is null or empty.");
        }
        if (isSw) {
            return new String(swApi.encrypt(plainText.getBytes(StandardCharsets.UTF_8)));
        }
        return new String(hwApi.encrypt(plainText.getBytes(StandardCharsets.UTF_8)));
    }

    public String decrypt(String cipherText, boolean isSw) throws AppException {
        if (StringUtils.isEmpty((CharSequence)cipherText)) {
            LOGGER.error("cipherText is null or empty.");
            throw new AppRuntimeException("cipherText is null or empty.");
        }
        if (isSw) {
            return new String(swApi.decrypt(cipherText.getBytes(StandardCharsets.UTF_8)));
        }
        return new String(hwApi.decrypt(cipherText.getBytes(StandardCharsets.UTF_8)));
    }

    public void kmcFinalized() {
        try {
            hwApi.finalized();
        }
        catch (AppException e) {
            LOGGER.error("hwApi finalized AppException:", (Throwable)e);
        }
        try {
            swApi.finalized();
        }
        catch (AppException e) {
            LOGGER.error("swApi finalized AppException:", (Throwable)e);
        }
    }

    public boolean isCryptoAPIExInit(boolean isHw) {
        if (isHw) {
            return hwApi.getInitStage() == InitStage.INIT_KMC_DONE.getValue();
        }
        return swApi.getInitStage() == InitStage.INIT_KMC_DONE.getValue();
    }

    public String encryptByFactoryKey(String plainText, boolean isChinese) throws AppException {
        if (!this.initializeKmc4FactoryKey(isChinese)) {
            throw new AppRuntimeException("initializeKmc4FactoryKey failed.");
        }
        if (StringUtils.isEmpty((CharSequence)plainText)) {
            LOGGER.error("plainText is null or empty.");
            throw new AppRuntimeException("plainText is null or empty.");
        }
        String result = "";
        try {
            result = new String(swApi4FactoryKey.encrypt(plainText.getBytes(StandardCharsets.UTF_8)));
        }
        catch (AppException e) {
            LOGGER.error("hwApi encrypt AppException:", (Throwable)e);
            throw e;
        }
        finally {
            swApi4FactoryKey.finalized();
        }
        this.checkEncryptResult(result);
        return result;
    }

    private boolean initializeKmc4FactoryKey(Boolean isChinese) {
        Properties appConfig = new Properties();
        appConfig.setProperty("domain_count", DOMAIN_COUNT);
        appConfig.setProperty("auto_update_mk_enabled", AUTO_UPDATE_MK_DISABLED);
        appConfig.setProperty("crypt_proc_sem_key", CRYPT_PROC_SEM_KEY);
        String factoryKeyPath = "webapps" + File.separator + "ROOT" + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "ksPath";
        File ksPath = this.getKsPath(factoryKeyPath);
        if (ksPath == null) {
            LOGGER.error("getKsPath failed when getKsPath.");
            throw new AppRuntimeException("getKsPath failed when getKsPath.");
        }
        String path = null;
        try {
            path = ksPath.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get canonical path fail: {}", (Object)ksPath, (Object)e);
            return false;
        }
        String primaryKeyStoreFile = path + SW_PRIMARY_KEY_STORE_FILE;
        String standbyKeyStoreFile = path + SW_STANDBY_KEY_STORE_FILE;
        appConfig.setProperty(SW_PRIMARY_KEY_STORE_FILE_KEY, primaryKeyStoreFile);
        appConfig.setProperty(SW_STANDBY_KEY_STORE_FILE_KEY, standbyKeyStoreFile);
        if (isChinese.booleanValue()) {
            this.setAppConfig4Chinese(appConfig);
        }
        return this.initializeKmcFun(swApi4FactoryKey, appConfig);
    }
}

