/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secas.kmc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ResponseHeaderFilter
implements Filter {
    private static final String MULTI_HEADER_SEPERATOR = ",";
    private Map<List<String>, String> headers = new HashMap<List<String>, String>();

    public void init(FilterConfig conf) throws ServletException {
        Enumeration paramNames = conf.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String headerList = (String)paramNames.nextElement();
            String value = conf.getInitParameter(headerList);
            this.headers.put(Arrays.asList(headerList.split(MULTI_HEADER_SEPERATOR)), value);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse resp = (HttpServletResponse)response;
        Set<List<String>> keySet = this.headers.keySet();
        for (List<String> key : keySet) {
            String value = this.headers.get(key).trim();
            for (String header : key) {
                header = header.trim();
                resp.setHeader(header, value);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

