/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secas.kmc.kmshardware;

import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.IHardwareCallback;
import com.huawei.kmc.common.JNIRefObj;
import com.huawei.secas.framework.AppRuntimeException;
import com.huawei.secas.kmc.kmshardware.KmsAddrModel;
import com.huawei.secas.kmc.kmshardware.KmsHttpUtil;
import com.huawei.secas.kmc.kmshardware.KmsKeyModel;
import com.huawei.secas.kmc.kmshardware.KmsResponseUtil;
import com.huawei.secas.kmc.kmshardware.KmsUserModel;
import com.huaweicloud.sdk.core.SdkResponse;
import com.huaweicloud.sdk.kms.v2.model.CreateKeyRequest;
import com.huaweicloud.sdk.kms.v2.model.CreateKeyRequestBody;
import com.huaweicloud.sdk.kms.v2.model.CreateKeyResponse;
import com.huaweicloud.sdk.kms.v2.model.CreateRandomRequest;
import com.huaweicloud.sdk.kms.v2.model.CreateRandomResponse;
import com.huaweicloud.sdk.kms.v2.model.DecryptDataRequest;
import com.huaweicloud.sdk.kms.v2.model.DecryptDataRequestBody;
import com.huaweicloud.sdk.kms.v2.model.DecryptDataResponse;
import com.huaweicloud.sdk.kms.v2.model.DeleteKeyRequest;
import com.huaweicloud.sdk.kms.v2.model.DeleteKeyResponse;
import com.huaweicloud.sdk.kms.v2.model.EncryptDataRequest;
import com.huaweicloud.sdk.kms.v2.model.EncryptDataRequestBody;
import com.huaweicloud.sdk.kms.v2.model.EncryptDataResponse;
import com.huaweicloud.sdk.kms.v2.model.GenRandomRequestBody;
import com.huaweicloud.sdk.kms.v2.model.ListKeysRequest;
import com.huaweicloud.sdk.kms.v2.model.ListKeysRequestBody;
import com.huaweicloud.sdk.kms.v2.model.ListKeysResponse;
import com.huaweicloud.sdk.kms.v2.model.ScheduleKeyDeletionRequestBody;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;

public class KmsHardwareCallback
extends IHardwareCallback {
    private static final int INIT_KMS_SUCCESS = 0;
    private static final String INIT_REQUEST_RANDOM_DATA_LENGTH = "16";
    private static final String KMS_FOR_KMC_KEY_ALIAS = "FusionCare-KmsForKmc-";
    private static final String KMS_DEL_KEY_PENDING_DAYS = "7";
    private static final int KMS_DEL_SUCCESS = 0;
    private static final int KMS_UUID_LENGTH = 36;
    private static final int KMS_BASE_CIPHER_TEXT_LEN = 124;
    private static final int KMS_CIPHER_BLOCK_LEN = 16;
    private static final float KMS_BASE64_RATIO_ONE = 3.0f;
    private static final float KMS_BASE64_RATION_TWO = 4.0f;
    private static final Object LOCK = new Object();
    private KmsUserModel userModel;
    private KmsAddrModel addrModel;
    private KmsKeyModel keyModel;

    public KmsHardwareCallback() {
    }

    public KmsHardwareCallback(KmsUserModel userModel, KmsAddrModel addrModel) {
        this.userModel = userModel;
        this.addrModel = addrModel;
    }

    public int hwInitKeyMgr() {
        CreateRandomRequest createRandomRequest = new CreateRandomRequest();
        GenRandomRequestBody genRandomRequestBody = new GenRandomRequestBody();
        genRandomRequestBody.setRandomDataLength(INIT_REQUEST_RANDOM_DATA_LENGTH);
        createRandomRequest.setBody(genRandomRequestBody);
        try {
            CreateRandomResponse createRandomResponse = KmsHttpUtil.getKmsClient(this.userModel, this.addrModel.getEndPoint()).createRandom(createRandomRequest);
            if (200 == createRandomResponse.getHttpStatusCode()) {
                return 0;
            }
            return KmsResponseUtil.checkResponse((SdkResponse)createRandomResponse);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JNIRefObj hwNewRootKey() throws Exception {
        JNIRefObj jniRefObj = new JNIRefObj();
        CreateKeyRequest createKeyRequest = new CreateKeyRequest();
        CreateKeyRequestBody createKeyRequestBody = new CreateKeyRequestBody();
        createKeyRequestBody.setKeyAlias(KMS_FOR_KMC_KEY_ALIAS + UUID.randomUUID());
        createKeyRequestBody.setKeySpec(CreateKeyRequestBody.KeySpecEnum.SM4);
        createKeyRequest.setBody(createKeyRequestBody);
        CreateKeyResponse createKeyResponse = KmsHttpUtil.getKmsClient(this.userModel, this.addrModel.getEndPoint()).createKey(createKeyRequest);
        KmsResponseUtil.checkResponseThrowAble((SdkResponse)createKeyResponse);
        byte[] result = createKeyResponse.getKeyInfo().getKeyId().getBytes(StandardCharsets.UTF_8);
        Object object = LOCK;
        synchronized (object) {
            jniRefObj.intVal = this.changeRkHandle(result);
        }
        jniRefObj.byteArr = result;
        return jniRefObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hwEncData(int rkIndex, byte[] extData, byte[] plainText) throws Exception {
        EncryptDataResponse encryptDataResponse;
        Object object = LOCK;
        synchronized (object) {
            EncryptDataRequest encryptDataRequest = new EncryptDataRequest();
            EncryptDataRequestBody encryptDataRequestBody = new EncryptDataRequestBody();
            encryptDataRequestBody.setKeyId(new String((byte[])this.rkHandle.get(rkIndex)));
            String base64Str = Base64.getEncoder().encodeToString(plainText);
            encryptDataRequestBody.setPlainText(base64Str);
            encryptDataRequest.setBody(encryptDataRequestBody);
            encryptDataResponse = KmsHttpUtil.getKmsClient(this.userModel, this.addrModel.getEndPoint()).encryptData(encryptDataRequest);
        }
        KmsResponseUtil.checkResponseThrowAble((SdkResponse)encryptDataResponse);
        return encryptDataResponse.getCipherText().getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hwDecData(int rkIndex, byte[] extData, byte[] cipherText) throws Exception {
        DecryptDataResponse decryptDataResponse;
        Object object = LOCK;
        synchronized (object) {
            if (ObjectUtils.isEmpty(this.rkHandle.get(rkIndex))) {
                throw new AppRuntimeException("Root key not found. Create new root key or load root key before use it.");
            }
            DecryptDataRequest decryptDataRequest = new DecryptDataRequest();
            DecryptDataRequestBody decryptDataRequestBody = new DecryptDataRequestBody();
            decryptDataRequestBody.setCipherText(new String(cipherText, Charset.defaultCharset()));
            decryptDataRequest.setBody(decryptDataRequestBody);
            decryptDataResponse = KmsHttpUtil.getKmsClient(this.userModel, this.addrModel.getEndPoint()).decryptData(decryptDataRequest);
        }
        KmsResponseUtil.checkResponseThrowAble((SdkResponse)decryptDataResponse);
        return Base64.getDecoder().decode(decryptDataResponse.getPlainText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hwRemoveKey(int rkIndex) throws Exception {
        DeleteKeyResponse deleteKeyResponse;
        Object object = LOCK;
        synchronized (object) {
            DeleteKeyRequest deleteKeyRequest = new DeleteKeyRequest();
            ScheduleKeyDeletionRequestBody scheduleKeyDeletionRequestBody = new ScheduleKeyDeletionRequestBody();
            scheduleKeyDeletionRequestBody.setKeyId(new String((byte[])this.rkHandle.get(rkIndex)));
            scheduleKeyDeletionRequestBody.setPendingDays(KMS_DEL_KEY_PENDING_DAYS);
            deleteKeyRequest.setBody(scheduleKeyDeletionRequestBody);
            deleteKeyResponse = KmsHttpUtil.getKmsClient(this.userModel, this.addrModel.getEndPoint()).deleteKey(deleteKeyRequest);
        }
        if (200 == deleteKeyResponse.getHttpStatusCode()) {
            return 0;
        }
        return KmsResponseUtil.checkResponse((SdkResponse)deleteKeyResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hwLoadRootKey(byte[] persistenceData) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.rkHandle = null == this.rkHandle ? new HashMap() : this.rkHandle;
            ListKeysRequest listKeysRequest = new ListKeysRequest();
            ListKeysRequestBody listKeysRequestBody = new ListKeysRequestBody();
            listKeysRequestBody.setKeySpec(ListKeysRequestBody.KeySpecEnum.ALL);
            listKeysRequest.setBody(listKeysRequestBody);
            ListKeysResponse listKeysResponse = KmsHttpUtil.getKmsClient(this.userModel, this.addrModel.getEndPoint()).listKeys(listKeysRequest);
            KmsResponseUtil.checkResponse((SdkResponse)listKeysResponse);
            if (listKeysResponse.getKeys().contains(new String(persistenceData, Charset.defaultCharset()))) {
                return this.getRkHandleIndex(persistenceData);
            }
        }
        throw new AppException("hwLoadRootKey fail.");
    }

    private int getRkHandleIndex(byte[] persistenceData) {
        if (ObjectUtils.isEmpty((Object)this.rkHandle)) {
            this.rkHandle.put(0, persistenceData);
            return 0;
        }
        for (Map.Entry entry : this.rkHandle.entrySet()) {
            if (!Arrays.equals(persistenceData, (byte[])entry.getValue())) continue;
            return (Integer)entry.getKey();
        }
        return this.changeRkHandle(persistenceData);
    }

    private int changeRkHandle(byte[] persistenceData) {
        int rkIndex = 0;
        if (ObjectUtils.isEmpty((Object)this.rkHandle)) {
            this.rkHandle = new HashMap();
        } else {
            Set set = this.rkHandle.keySet();
            Object[] obj = set.toArray();
            Arrays.sort(obj);
            rkIndex = (Integer)obj[obj.length - 1] + 1;
        }
        this.rkHandle.put(rkIndex, persistenceData);
        return rkIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hwUnLoadRootKey(int rkIndex) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.rkHandle.remove(rkIndex);
        }
        return 0;
    }

    public int hwUinitKeyMgr() {
        return 0;
    }

    public byte[] hwGetEncExtraData() throws Exception {
        return new byte[0];
    }

    public byte[] hwGetDecExtraData() throws Exception {
        return new byte[0];
    }

    public int hwGetPersistentDataLen() throws Exception {
        return 36;
    }

    public int hwGetCipherLen(int plainLen) throws Exception {
        if (plainLen < 0) {
            throw new AppRuntimeException("Plain text should be less than zero.");
        }
        int realLen = (int)(124.0 + 16.0 * (Math.ceil((float)plainLen / 3.0f) / 4.0 + 1.0));
        int base64Len = (int)Math.ceil((float)realLen / 3.0f * 4.0f);
        return base64Len;
    }

    public KmsUserModel getUserModel() {
        return this.userModel;
    }

    public void setUserModel(KmsUserModel userModel) {
        this.userModel = userModel;
    }

    public KmsAddrModel getAddrModel() {
        return this.addrModel;
    }

    public void setAddrModel(KmsAddrModel addrModel) {
        this.addrModel = addrModel;
    }

    public void setKeyModel(KmsKeyModel keyModel) {
        this.keyModel = keyModel;
    }

    public KmsKeyModel getKeyModel() {
        return this.keyModel;
    }
}

