/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secas.kmc.kmshardware;

import com.huawei.secas.framework.AppRuntimeException;
import com.huaweicloud.sdk.core.SdkResponse;

public class KmsResponseUtil {
    private static final int REQUEST_KMS_BAD_REQUEST = 1;
    private static final int REQUEST_KMS_NEED_AUTH = 2;
    private static final int REQUEST_KMS_NEED_PERMISSION = 3;
    private static final int REQUEST_KMS_NEED_RETRY = 4;
    private static final int REQUEST_KMS_NEED_REACH = 5;
    private static final int REQUEST_KMS_NEED_FOUND = 6;

    public static int checkResponse(SdkResponse response) {
        if (400 == response.getHttpStatusCode()) {
            return 1;
        }
        if (401 == response.getHttpStatusCode()) {
            return 2;
        }
        if (403 == response.getHttpStatusCode()) {
            return 3;
        }
        if (404 == response.getHttpStatusCode()) {
            return 6;
        }
        if (429 == response.getHttpStatusCode()) {
            return 4;
        }
        if (500 <= response.getHttpStatusCode()) {
            return 5;
        }
        return response.getHttpStatusCode();
    }

    public static void checkResponseThrowAble(SdkResponse response) {
        if (200 == response.getHttpStatusCode() || 204 == response.getHttpStatusCode()) {
            return;
        }
        if (400 == response.getHttpStatusCode()) {
            throw new AppRuntimeException("Bad Request");
        }
        if (401 == response.getHttpStatusCode()) {
            throw new AppRuntimeException("Need Auth");
        }
        if (403 == response.getHttpStatusCode()) {
            throw new AppRuntimeException("Need Permission");
        }
        if (404 == response.getHttpStatusCode()) {
            throw new AppRuntimeException("Need Found");
        }
        if (429 == response.getHttpStatusCode()) {
            throw new AppRuntimeException("Need Retry after a While");
        }
        if (500 <= response.getHttpStatusCode()) {
            throw new AppRuntimeException("Can not reach");
        }
        throw new AppRuntimeException("Unknown error. HttpCode is " + response.getHttpStatusCode());
    }
}

