/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AKSKSigner;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.ISigningKey;
import com.huaweicloud.sdk.core.exception.SdkException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;

public class P256SHA256Signer
extends AKSKSigner {
    private static volatile P256SHA256Signer instance;
    protected ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"P-256");
    protected BigInteger nMinusTwo = this.ecSpec.getN().subtract(BigInteger.valueOf(2L));

    protected P256SHA256Signer() {
        this.algorithm = "SDK-ECDSA-P256-SHA256";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static P256SHA256Signer getInstance() {
        if (Objects.nonNull(instance)) {
            return instance;
        }
        Class<P256SHA256Signer> clazz = P256SHA256Signer.class;
        synchronized (P256SHA256Signer.class) {
            if (instance == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                instance = new P256SHA256Signer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public <T extends AbstractCredentials<T>> ISigningKey getSigningKey(T credentials) {
        BigInteger privateInt = this.derivePrivateInt(credentials);
        return this.generateSigningKey(privateInt);
    }

    protected ISigningKey generateSigningKey(BigInteger candidate) {
        ECParameterSpec ecParameterSpec = new ECParameterSpec(this.ecSpec.getCurve(), this.ecSpec.getG(), this.ecSpec.getN(), this.ecSpec.getH(), this.ecSpec.getSeed());
        ECDomainParameters domainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN(), ecParameterSpec.getH());
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(candidate, domainParameters);
        ECPoint ecPoint = this.ecSpec.getCurve().getMultiplier().multiply(this.ecSpec.getG(), candidate);
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(ecPoint, domainParameters);
        return this.initSigningKey(privateKeyParameters, publicKeyParameters);
    }

    protected ISigningKey initSigningKey(ECPrivateKeyParameters privateKeyParameters, ECPublicKeyParameters publicKeyParameters) {
        return new P256SigningKey(privateKeyParameters, publicKeyParameters);
    }

    private <T extends AbstractCredentials<T>> BigInteger derivePrivateInt(T credentials) {
        ByteBuffer context = ByteBuffer.allocate(21);
        ByteBuffer data = ByteBuffer.allocate(this.algorithm.length() + 30);
        for (int counter = 0; counter <= 255; ++counter) {
            context.clear();
            data.clear();
            context.put(credentials.getAk().getBytes(StandardCharsets.UTF_8));
            context.put((byte)counter);
            data.put(new byte[]{0, 0, 0, 1});
            data.put(this.algorithm.getBytes(StandardCharsets.UTF_8));
            data.put((byte)0);
            data.put(context.array(), 0, context.position());
            data.put(new byte[]{0, 0, 1, 0});
            byte[] hmacBytes = this.hasher.hmac(data.array(), credentials.getSk().getBytes(StandardCharsets.UTF_8));
            BigInteger candidate = new BigInteger(1, hmacBytes);
            if (candidate.compareTo(this.nMinusTwo) > 0) continue;
            return candidate.add(BigInteger.ONE);
        }
        throw new SdkException("derive candidate failed, counter out of range");
    }

    class P256SigningKey
    implements ISigningKey {
        protected final ECPrivateKeyParameters privateKeyParameters;
        protected final ECPublicKeyParameters publicKeyParameters;

        P256SigningKey(ECPrivateKeyParameters privateKeyParameters, ECPublicKeyParameters publicKeyParameters) {
            this.privateKeyParameters = privateKeyParameters;
            this.publicKeyParameters = publicKeyParameters;
        }

        @Override
        public byte[] sign(byte[] data) {
            ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
            signer.init(true, (CipherParameters)this.privateKeyParameters);
            byte[] hashed = P256SHA256Signer.this.hasher.hash(data);
            BigInteger[] integers = signer.generateSignature(hashed);
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new ASN1Integer(integers[0]));
            vector.add((ASN1Encodable)new ASN1Integer(integers[1]));
            DERSequence derSequence = new DERSequence(vector);
            try {
                return derSequence.getEncoded();
            }
            catch (IOException e) {
                throw new SdkException("failed to encode data to ASN.1-DER format", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean verify(byte[] signature, byte[] data) {
            try (ASN1InputStream as = new ASN1InputStream(signature);){
                ASN1Sequence asn1Sequence = (ASN1Sequence)as.readObject();
                BigInteger r = ((ASN1Integer)asn1Sequence.getObjectAt(0)).getValue();
                BigInteger s = ((ASN1Integer)asn1Sequence.getObjectAt(1)).getValue();
                ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
                signer.init(false, (CipherParameters)this.publicKeyParameters);
                byte[] hashed = P256SHA256Signer.this.hasher.hash(data);
                boolean bl = signer.verifySignature(hashed, r, s);
                return bl;
            }
            catch (IOException | ClassCastException e) {
                return false;
            }
        }
    }
}

