/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huaweicloud.sdk.core.http.Field;
import com.huaweicloud.sdk.core.http.FieldExistence;
import com.huaweicloud.sdk.core.http.FieldImpl;
import com.huaweicloud.sdk.core.http.HttpMethod;
import com.huaweicloud.sdk.core.http.LocationType;
import com.huaweicloud.sdk.core.http.VoidBody;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface HttpRequestDef<R, S> {
    public static <R, S> Builder<R, S> builder(HttpMethod method, Class<R> r, Class<S> t) {
        Builder<R, S> builder = new Builder<R, S>(method, r, t);
        builder.impl.requestClass = r;
        builder.impl.responseClass = t;
        builder.impl.method = method;
        return builder;
    }

    public Builder<R, S> builder();

    @JsonIgnore
    public Class<R> getRequestType();

    @JsonIgnore
    public Class<S> getResponseType();

    @JsonIgnore
    public HttpMethod getMethod();

    @JsonIgnore
    public String getContentType();

    @JsonIgnore
    public String getUri();

    @JsonIgnore
    public String getName();

    @JsonIgnore
    public List<Field<R, ?>> getRequestFields();

    @JsonIgnore
    public <T> Field<R, T> getRequestField(String var1);

    public boolean hasRequestField(String var1);

    @JsonIgnore
    public List<Field<S, ?>> getResponseFields();

    @JsonIgnore
    public Field<S, ?> getResponseField(String var1);

    public boolean hasResponseField(String var1);

    public static class Impl<R, T>
    implements HttpRequestDef<R, T> {
        Class<R> requestClass;
        Class<T> responseClass;
        String name;
        String uri;
        HttpMethod method;
        String contentType;
        List<Field<R, ?>> requestFields = new ArrayList();
        Map<String, Field<R, ?>> requestFieldsMap;
        List<Field<T, ?>> responseFields = new ArrayList();
        Map<String, Field<T, ?>> responseFieldsMap;

        @Override
        public Class<R> getRequestType() {
            return this.requestClass;
        }

        @Override
        public Class<T> getResponseType() {
            return this.responseClass;
        }

        @Override
        public HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public List<Field<R, ?>> getRequestFields() {
            return this.requestFields;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public <T> Field<R, T> getRequestField(String name) {
            if (this.requestFieldsMap == null) {
                throw new IllegalAccessError("design issue. never happy");
            }
            Field<R, ?> f = this.requestFieldsMap.get(name);
            Objects.requireNonNull(f, "getRequestField name not exist. this function is used for machine usage. so in strict mode");
            return f;
        }

        @Override
        public List<Field<T, ?>> getResponseFields() {
            return this.responseFields;
        }

        @Override
        public Field<T, ?> getResponseField(String name) {
            if (this.responseFieldsMap == null) {
                throw new IllegalAccessError("design issue. never happy");
            }
            Field<T, ?> f = this.responseFieldsMap.get(name);
            Objects.requireNonNull(f, "getResponseField " + name + " not exist. this function is used for machine usage. so in strict mode");
            return f;
        }

        @Override
        public boolean hasRequestField(String name) {
            if (this.requestFieldsMap == null) {
                throw new IllegalAccessError("design issue. never happy");
            }
            return this.requestFieldsMap.containsKey(name);
        }

        @Override
        public boolean hasResponseField(String name) {
            if (this.responseFieldsMap == null) {
                throw new IllegalAccessError("design issue. never happy");
            }
            return this.responseFieldsMap.containsKey(name);
        }

        @Override
        public Builder<R, T> builder() {
            return new Builder(this);
        }
    }

    public static class Builder<R, T> {
        Impl<R, T> impl;

        public Builder(HttpMethod method, Class<R> r, Class<T> t) {
            this.impl = new Impl();
            this.impl.requestClass = r;
            this.impl.responseClass = t;
            this.impl.method = method;
        }

        public Builder(Impl<R, T> impl) {
            this.impl = impl;
        }

        public HttpRequestDef<R, T> build() {
            this.impl.requestFields = Collections.unmodifiableList(this.impl.requestFields);
            this.impl.requestFieldsMap = this.impl.requestFields.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
            this.impl.responseFields = Collections.unmodifiableList(this.impl.responseFields);
            this.impl.responseFieldsMap = this.impl.responseFields.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
            return this.impl;
        }

        public Builder<R, T> withUri(String path) {
            this.impl.uri = path;
            return this;
        }

        public Builder<R, T> withName(String name) {
            this.impl.name = name;
            return this;
        }

        public Builder<R, T> withContentType(String contentType) {
            this.impl.contentType = contentType;
            return this;
        }

        public <FieldT> Builder<R, T> withRequestField(Field<R, FieldT> field) {
            this.impl.requestFields.add(field);
            return this;
        }

        public <FieldT> Builder<R, T> withRequestField(String name, LocationType locationType, FieldExistence existence, Class<FieldT> fieldType, Consumer<FieldImpl<R, FieldT>> setter) {
            FieldImpl field = new FieldImpl(name, locationType, existence, fieldType);
            setter.accept(field);
            this.impl.requestFields.add(field);
            return this;
        }

        public <FieldT> Builder<R, T> withResponseField(Field<T, FieldT> field) {
            this.impl.responseFields.add(field);
            return this;
        }

        public <FieldT> Builder<R, T> withResponseField(String name, LocationType locationType, FieldExistence existence, Class<FieldT> fieldType, Consumer<FieldImpl<T, FieldT>> setter) {
            FieldImpl field = new FieldImpl(name, locationType, existence, fieldType);
            setter.accept(field);
            this.impl.responseFields.add(field);
            return this;
        }

        public Builder<R, T> withResponseVoidBody(String nameOfCode, BiConsumer<T, VoidBody> writer) {
            return this.withResponseField(nameOfCode, LocationType.Body, FieldExistence.NULL_IGNORE, VoidBody.class, field -> field.withMarshaller(response -> new VoidBody(), writer));
        }
    }
}

