/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

public enum KdfAlgForPwd {
    PWD_UNKNOWN_ALGORITHM("PWD_UNKNOWN_ALGORITHM", 0),
    PWD_PBKDF2_HMAC_SHA256("PWD_PBKDF2_HMAC_SHA256", 3076),
    PWD_PBKDF2_HMAC_SHA384("PWD_PBKDF2_HMAC_SHA384", 3077),
    PWD_PBKDF2_HMAC_SHA512("PWD_PBKDF2_HMAC_SHA512", 3078),
    PWD_PBKDF2_HMAC_SM3("PWD_PBKDF2_HMAC_SM3", 3079);

    private String kdfAlg;
    private int value;

    private KdfAlgForPwd(String kdfAlg, int value) {
        this.kdfAlg = kdfAlg;
        this.value = value;
    }

    public static KdfAlgForPwd searchByName(String name) {
        if (name == null || name.isEmpty()) {
            return PWD_UNKNOWN_ALGORITHM;
        }
        KdfAlgForPwd algTemp = null;
        try {
            algTemp = KdfAlgForPwd.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            algTemp = PWD_UNKNOWN_ALGORITHM;
        }
        return algTemp;
    }

    public String getStringValue() {
        return this.kdfAlg;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "**not support toString**";
    }
}

