/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kms.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class CreateGrantRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="key_id")
    private String keyId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="grantee_principal")
    private String granteePrincipal;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="operations")
    private List<String> operations = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="retiring_principal")
    private String retiringPrincipal;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="grantee_principal_type")
    private GranteePrincipalTypeEnum granteePrincipalType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sequence")
    private String sequence;

    public CreateGrantRequestBody withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public CreateGrantRequestBody withGranteePrincipal(String granteePrincipal) {
        this.granteePrincipal = granteePrincipal;
        return this;
    }

    public String getGranteePrincipal() {
        return this.granteePrincipal;
    }

    public void setGranteePrincipal(String granteePrincipal) {
        this.granteePrincipal = granteePrincipal;
    }

    public CreateGrantRequestBody withOperations(List<String> operations) {
        this.operations = operations;
        return this;
    }

    public CreateGrantRequestBody addOperationsItem(String operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    public CreateGrantRequestBody withOperations(Consumer<List<String>> operationsSetter) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        operationsSetter.accept(this.operations);
        return this;
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    public CreateGrantRequestBody withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateGrantRequestBody withRetiringPrincipal(String retiringPrincipal) {
        this.retiringPrincipal = retiringPrincipal;
        return this;
    }

    public String getRetiringPrincipal() {
        return this.retiringPrincipal;
    }

    public void setRetiringPrincipal(String retiringPrincipal) {
        this.retiringPrincipal = retiringPrincipal;
    }

    public CreateGrantRequestBody withGranteePrincipalType(GranteePrincipalTypeEnum granteePrincipalType) {
        this.granteePrincipalType = granteePrincipalType;
        return this;
    }

    public GranteePrincipalTypeEnum getGranteePrincipalType() {
        return this.granteePrincipalType;
    }

    public void setGranteePrincipalType(GranteePrincipalTypeEnum granteePrincipalType) {
        this.granteePrincipalType = granteePrincipalType;
    }

    public CreateGrantRequestBody withSequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateGrantRequestBody that = (CreateGrantRequestBody)obj;
        return Objects.equals(this.keyId, that.keyId) && Objects.equals(this.granteePrincipal, that.granteePrincipal) && Objects.equals(this.operations, that.operations) && Objects.equals(this.name, that.name) && Objects.equals(this.retiringPrincipal, that.retiringPrincipal) && Objects.equals(this.granteePrincipalType, that.granteePrincipalType) && Objects.equals(this.sequence, that.sequence);
    }

    public int hashCode() {
        return Objects.hash(this.keyId, this.granteePrincipal, this.operations, this.name, this.retiringPrincipal, this.granteePrincipalType, this.sequence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateGrantRequestBody {\n");
        sb.append("    keyId: ").append(this.toIndentedString(this.keyId)).append("\n");
        sb.append("    granteePrincipal: ").append(this.toIndentedString(this.granteePrincipal)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    retiringPrincipal: ").append(this.toIndentedString(this.retiringPrincipal)).append("\n");
        sb.append("    granteePrincipalType: ").append(this.toIndentedString(this.granteePrincipalType)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class GranteePrincipalTypeEnum {
        public static final GranteePrincipalTypeEnum USER = new GranteePrincipalTypeEnum("user");
        public static final GranteePrincipalTypeEnum DOMAIN = new GranteePrincipalTypeEnum("domain");
        private static final Map<String, GranteePrincipalTypeEnum> STATIC_FIELDS = GranteePrincipalTypeEnum.createStaticFields();
        private String value;

        private static Map<String, GranteePrincipalTypeEnum> createStaticFields() {
            HashMap<String, GranteePrincipalTypeEnum> map = new HashMap<String, GranteePrincipalTypeEnum>();
            map.put("user", USER);
            map.put("domain", DOMAIN);
            return Collections.unmodifiableMap(map);
        }

        GranteePrincipalTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GranteePrincipalTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new GranteePrincipalTypeEnum(value));
        }

        public static GranteePrincipalTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof GranteePrincipalTypeEnum) {
                return this.value.equals(((GranteePrincipalTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

