/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kms.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DecryptDataRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cipher_text")
    private String cipherText;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="encryption_algorithm")
    private EncryptionAlgorithmEnum encryptionAlgorithm;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="key_id")
    private String keyId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sequence")
    private String sequence;

    public DecryptDataRequestBody withCipherText(String cipherText) {
        this.cipherText = cipherText;
        return this;
    }

    public String getCipherText() {
        return this.cipherText;
    }

    public void setCipherText(String cipherText) {
        this.cipherText = cipherText;
    }

    public DecryptDataRequestBody withEncryptionAlgorithm(EncryptionAlgorithmEnum encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public EncryptionAlgorithmEnum getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithmEnum encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public DecryptDataRequestBody withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public DecryptDataRequestBody withSequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DecryptDataRequestBody that = (DecryptDataRequestBody)obj;
        return Objects.equals(this.cipherText, that.cipherText) && Objects.equals(this.encryptionAlgorithm, that.encryptionAlgorithm) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.sequence, that.sequence);
    }

    public int hashCode() {
        return Objects.hash(this.cipherText, this.encryptionAlgorithm, this.keyId, this.sequence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecryptDataRequestBody {\n");
        sb.append("    cipherText: ").append(this.toIndentedString(this.cipherText)).append("\n");
        sb.append("    encryptionAlgorithm: ").append(this.toIndentedString(this.encryptionAlgorithm)).append("\n");
        sb.append("    keyId: ").append(this.toIndentedString(this.keyId)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EncryptionAlgorithmEnum {
        public static final EncryptionAlgorithmEnum SYMMETRIC_DEFAULT = new EncryptionAlgorithmEnum("SYMMETRIC_DEFAULT");
        public static final EncryptionAlgorithmEnum RSAES_OAEP_SHA_256 = new EncryptionAlgorithmEnum("RSAES_OAEP_SHA_256");
        public static final EncryptionAlgorithmEnum SM2_ENCRYPT = new EncryptionAlgorithmEnum("SM2_ENCRYPT");
        private static final Map<String, EncryptionAlgorithmEnum> STATIC_FIELDS = EncryptionAlgorithmEnum.createStaticFields();
        private String value;

        private static Map<String, EncryptionAlgorithmEnum> createStaticFields() {
            HashMap<String, EncryptionAlgorithmEnum> map = new HashMap<String, EncryptionAlgorithmEnum>();
            map.put("SYMMETRIC_DEFAULT", SYMMETRIC_DEFAULT);
            map.put("RSAES_OAEP_SHA_256", RSAES_OAEP_SHA_256);
            map.put("SM2_ENCRYPT", SM2_ENCRYPT);
            return Collections.unmodifiableMap(map);
        }

        EncryptionAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncryptionAlgorithmEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EncryptionAlgorithmEnum(value));
        }

        public static EncryptionAlgorithmEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncryptionAlgorithmEnum) {
                return this.value.equals(((EncryptionAlgorithmEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

