/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kms.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SignRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="key_id")
    private String keyId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="message")
    private String message;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="signing_algorithm")
    private SigningAlgorithmEnum signingAlgorithm;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="message_type")
    private MessageTypeEnum messageType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sequence")
    private String sequence;

    public SignRequestBody withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public SignRequestBody withMessage(String message) {
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SignRequestBody withSigningAlgorithm(SigningAlgorithmEnum signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    public SigningAlgorithmEnum getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(SigningAlgorithmEnum signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public SignRequestBody withMessageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
        return this;
    }

    public MessageTypeEnum getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
    }

    public SignRequestBody withSequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SignRequestBody that = (SignRequestBody)obj;
        return Objects.equals(this.keyId, that.keyId) && Objects.equals(this.message, that.message) && Objects.equals(this.signingAlgorithm, that.signingAlgorithm) && Objects.equals(this.messageType, that.messageType) && Objects.equals(this.sequence, that.sequence);
    }

    public int hashCode() {
        return Objects.hash(this.keyId, this.message, this.signingAlgorithm, this.messageType, this.sequence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignRequestBody {\n");
        sb.append("    keyId: ").append(this.toIndentedString(this.keyId)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    signingAlgorithm: ").append(this.toIndentedString(this.signingAlgorithm)).append("\n");
        sb.append("    messageType: ").append(this.toIndentedString(this.messageType)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class MessageTypeEnum {
        public static final MessageTypeEnum DIGEST = new MessageTypeEnum("DIGEST");
        public static final MessageTypeEnum RAW = new MessageTypeEnum("RAW");
        private static final Map<String, MessageTypeEnum> STATIC_FIELDS = MessageTypeEnum.createStaticFields();
        private String value;

        private static Map<String, MessageTypeEnum> createStaticFields() {
            HashMap<String, MessageTypeEnum> map = new HashMap<String, MessageTypeEnum>();
            map.put("DIGEST", DIGEST);
            map.put("RAW", RAW);
            return Collections.unmodifiableMap(map);
        }

        MessageTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MessageTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new MessageTypeEnum(value));
        }

        public static MessageTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof MessageTypeEnum) {
                return this.value.equals(((MessageTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class SigningAlgorithmEnum {
        public static final SigningAlgorithmEnum RSASSA_PSS_SHA_256 = new SigningAlgorithmEnum("RSASSA_PSS_SHA_256");
        public static final SigningAlgorithmEnum RSASSA_PSS_SHA_384 = new SigningAlgorithmEnum("RSASSA_PSS_SHA_384");
        public static final SigningAlgorithmEnum RSASSA_PSS_SHA_512 = new SigningAlgorithmEnum("RSASSA_PSS_SHA_512");
        public static final SigningAlgorithmEnum RSASSA_PKCS1_V1_5_SHA_256 = new SigningAlgorithmEnum("RSASSA_PKCS1_V1_5_SHA_256");
        public static final SigningAlgorithmEnum RSASSA_PKCS1_V1_5_SHA_384 = new SigningAlgorithmEnum("RSASSA_PKCS1_V1_5_SHA_384");
        public static final SigningAlgorithmEnum RSASSA_PKCS1_V1_5_SHA_512 = new SigningAlgorithmEnum("RSASSA_PKCS1_V1_5_SHA_512");
        public static final SigningAlgorithmEnum ECDSA_SHA_256 = new SigningAlgorithmEnum("ECDSA_SHA_256");
        public static final SigningAlgorithmEnum ECDSA_SHA_384 = new SigningAlgorithmEnum("ECDSA_SHA_384");
        public static final SigningAlgorithmEnum ECDSA_SHA_512 = new SigningAlgorithmEnum("ECDSA_SHA_512");
        public static final SigningAlgorithmEnum SM2DSA_SM3 = new SigningAlgorithmEnum("SM2DSA_SM3");
        private static final Map<String, SigningAlgorithmEnum> STATIC_FIELDS = SigningAlgorithmEnum.createStaticFields();
        private String value;

        private static Map<String, SigningAlgorithmEnum> createStaticFields() {
            HashMap<String, SigningAlgorithmEnum> map = new HashMap<String, SigningAlgorithmEnum>();
            map.put("RSASSA_PSS_SHA_256", RSASSA_PSS_SHA_256);
            map.put("RSASSA_PSS_SHA_384", RSASSA_PSS_SHA_384);
            map.put("RSASSA_PSS_SHA_512", RSASSA_PSS_SHA_512);
            map.put("RSASSA_PKCS1_V1_5_SHA_256", RSASSA_PKCS1_V1_5_SHA_256);
            map.put("RSASSA_PKCS1_V1_5_SHA_384", RSASSA_PKCS1_V1_5_SHA_384);
            map.put("RSASSA_PKCS1_V1_5_SHA_512", RSASSA_PKCS1_V1_5_SHA_512);
            map.put("ECDSA_SHA_256", ECDSA_SHA_256);
            map.put("ECDSA_SHA_384", ECDSA_SHA_384);
            map.put("ECDSA_SHA_512", ECDSA_SHA_512);
            map.put("SM2DSA_SM3", SM2DSA_SM3);
            return Collections.unmodifiableMap(map);
        }

        SigningAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SigningAlgorithmEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new SigningAlgorithmEnum(value));
        }

        public static SigningAlgorithmEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SigningAlgorithmEnum) {
                return this.value.equals(((SigningAlgorithmEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

