#!/bin/bash

baseDir=
classPath=

getBaseDir()
{
	local SOURCE="$0"
	local DIR=

	while [ -h "$SOURCE" ]; do 
	    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
   		SOURCE="$(readlink "$SOURCE")"
    	[[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE"
	done
	
	DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
	baseDir=$DIR/../

	return 0
}

getClassPath()
{
	local path=$CLASS_PATH
	local libs=$(find ${baseDir}/lib/secas -maxdepth 1 -name "*.jar")

	path=${baseDir}/lib:${path}
	for lib in $libs
	do
		path=$lib:$path
	done

	classPath=$path

	return 0
}

setEnv()
{
	getBaseDir || { return 1; }
	getClassPath || { return 1; }
}

checkParam()
{
	user=`whoami`
	if [ $user == "root" ]; then
		echo "Please run with [tomcatuser]"
		return 1;
	fi
	return 0;
}

main()
{
	setEnv || { return 1; }
	checkParam || { return 1; }
	
	className="com.huawei.secas.kmc.KSPass"
	export LD_LIBRARY_PATH=$baseDir/../jre/bin
	userName=`whoami`
	log4jConf="file:${baseDir}/lib/log4j2.xml"
	KSPass="java -cp $classPath -Dlog4j.configuration=${log4jConf} -Dcatalina.home=$baseDir $className"
	cd $baseDir > /dev/null
	$KSPass "$userName" "$@"
	cd - > /dev/null

	return 0
}

if [[ "`whoami`" == "root" ]];then
	echo "Can not run with root"
	exit -1
fi 

main "$@" 2>/dev/null
