/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.scene.utils;

import com.huawei.ism.tool.base.scene.utils.SceneKey;
import com.huawei.ism.tool.base.scene.utils.SceneValue;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.python.google.common.io.Files;
import org.slf4j.Logger;

public class SceneDataExchange {
    public static final String END_KEY = "endKey:";
    public static final String DATA = "data:";
    public static final String DESTINATION = "destination:";
    public static final String START_KEY = "startKey:";
    public static final String SOURCE = "source:";
    public static final char ATTR_SEP = ':';
    private static final String TEMP_PATH = SystemEnvUtil.getDefaultUserDir() + File.separator + "temp";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneEnvironmentImpl.class);
    private static volatile SceneDataExchange instance;
    private File filePath;
    private File filePathLock;
    private boolean isInited = false;
    private File reportFile;
    private Map<String, String> cacheMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SceneDataExchange getInstance() {
        if (instance != null) return instance;
        Class<SceneDataExchange> clazz = SceneDataExchange.class;
        synchronized (SceneDataExchange.class) {
            if (instance != null) return instance;
            instance = new SceneDataExchange();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SceneDataExchange() {
        this.initDataExchange();
    }

    public synchronized void initDataExchange() {
        try {
            File tmpFile = new File(TEMP_PATH);
            if (!tmpFile.exists() && !tmpFile.mkdir()) {
                LOGGER.error("Make dir error:" + tmpFile.toString());
            }
            String subPath = File.separator + "exchange" + File.separator;
            this.filePath = new File(tmpFile.getCanonicalPath() + subPath + "exchange.data");
            this.filePathLock = new File(tmpFile.getCanonicalPath() + subPath + "exchange.lock");
            boolean dirResult = this.filePathLock.getParentFile().mkdir();
            boolean result = this.filePathLock.createNewFile();
            boolean dataResult = this.filePath.createNewFile();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("data file: " + this.filePath + " lock file: " + this.filePathLock + " create result:" + result + " dir result:" + dirResult + " dataResultL" + dataResult);
            }
            this.isInited = true;
            for (Map.Entry<String, String> entry : this.cacheMap.entrySet()) {
                this.saveKV(entry.getKey(), entry.getValue());
            }
            this.cacheMap.clear();
        }
        catch (Exception e) {
            LOGGER.error("init scene error", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized String loadKV(String keyStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<SceneKey, SceneValue> loadAllKv(BufferedReader br) throws IOException {
        String line;
        LinkedHashMap<SceneKey, SceneValue> result = new LinkedHashMap<SceneKey, SceneValue>();
        boolean isStartMatch = false;
        boolean isDataMatch = false;
        SceneKey key = new SceneKey();
        SceneValue value = new SceneValue(null);
        StringBuilder data = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if ((line = Normalizer.normalize(line, Normalizer.Form.NFKC)).startsWith(START_KEY)) {
                key = new SceneKey();
                value = new SceneValue(null);
                data = new StringBuilder();
                isStartMatch = true;
                key.setKey(line.substring(line.indexOf(58) + 1));
                continue;
            }
            if (isStartMatch && line.startsWith(SOURCE)) {
                key.setSource(line.substring(line.indexOf(58) + 1));
                continue;
            }
            if (isStartMatch && line.startsWith(DESTINATION)) {
                key.setDestination(line.substring(line.indexOf(58) + 1));
                continue;
            }
            if (isStartMatch && line.startsWith(DATA)) {
                data.append(line.substring(line.indexOf(58) + 1));
                isDataMatch = true;
                continue;
            }
            if (isStartMatch && isDataMatch && line.trim().equals(END_KEY + key.getKey())) {
                isStartMatch = false;
                isDataMatch = false;
                value.setData(data.toString());
                result.put(key, value);
                key = null;
                value = null;
                continue;
            }
            if (isDataMatch) {
                data.append(System.lineSeparator()).append(line);
                continue;
            }
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("exception data:" + line);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void saveKV(String keyStr, String value) {
        block48: {
            if (!this.isInited) {
                this.initDataExchange();
                if (!this.isInited) {
                    this.cacheMap.put(keyStr, value);
                    LOGGER.error("saveKV cur is not initialized properply.");
                    return;
                }
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("start to save KV,key :" + keyStr + " value:" + value);
            }
            SceneKey key = new SceneKey(keyStr, null, null);
            FileLock fl = null;
            FileOutputStream os = null;
            try {
                try (RandomAccessFile raf = new RandomAccessFile(this.filePathLock, "rw");
                     BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filePath), Charset.defaultCharset()));
                     FileChannel channel = raf.getChannel();){
                    fl = channel.lock();
                    Map<SceneKey, SceneValue> exMap = this.loadAllKv(br);
                    os = new FileOutputStream(this.filePath);
                    exMap.put(key, new SceneValue(value));
                    for (Map.Entry<SceneKey, SceneValue> entry : exMap.entrySet()) {
                        os.write(this.getStorStr(entry.getKey(), entry.getValue()).getBytes(Charset.defaultCharset()));
                    }
                }
                StreamUtils.closeResource(os, os);
            }
            catch (RuntimeException e) {
                LOGGER.error("saveKV error RuntimeException!!!", (Throwable)e);
                break block48;
            }
            catch (Exception e2) {
                LOGGER.error("saveKV error!!!", (Throwable)e2);
                break block48;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeResource(os, os);
                this.releaseLock(fl);
            }
            this.releaseLock(fl);
        }
    }

    public String getStorStr(SceneKey key, SceneValue value) {
        return START_KEY + key.getKey() + System.lineSeparator() + SOURCE + key.getSource() + System.lineSeparator() + DESTINATION + key.getDestination() + System.lineSeparator() + DATA + value.getData() + System.lineSeparator() + (END_KEY + key.getKey()) + System.lineSeparator();
    }

    private void releaseLock(FileLock fl) {
        if (fl != null && fl.isValid()) {
            try {
                fl.release();
            }
            catch (Exception e) {
                LOGGER.error("error release lock.", (Throwable)e);
            }
        }
    }

    public synchronized void copyDataFileToPath(String toPath) {
        try {
            File file = new File(toPath).getParentFile();
            if (!file.exists() && LOGGER.isInfoEnabled()) {
                LOGGER.info("mkdir result :" + new File(toPath).mkdir());
            }
            Files.copy((File)this.filePath, (File)new File(toPath));
        }
        catch (Exception e) {
            LOGGER.error("copy error", (Throwable)e);
        }
    }

    public synchronized void setExchangeDataPath(File reportFile) {
        this.reportFile = reportFile;
    }
}

