/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class HtmlResUtils {
    private static final String DEFAULT_RESOURCE_DIR = "config";
    private static final String DEFAULT_HTML_DIR = "html";
    private static final String DEFAULT_PROPERTIES_NAME = "htmlresource";
    private static final String DEFAULT_STRING = "--";

    private HtmlResUtils() {
    }

    public static String getString(String key) {
        Class<HtmlResUtils> invokerCls = HtmlResUtils.class;
        String ctxPkg = ContextUtil.getContextPackageName(invokerCls);
        ClassLoader cl = ContextUtil.getContextClassLoader(invokerCls);
        String htmlLanguageResource = HtmlResUtils.getPropertiesCfg(ctxPkg);
        ResourceBundle resource = ResourceBundle.getBundle(htmlLanguageResource, LanguageManager.getInstance().getCurrentLanguage(), cl);
        String value = null;
        try {
            value = resource.getString(key);
        }
        catch (MissingResourceException e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find resource:" + key);
        }
        return null == value ? DEFAULT_STRING : value;
    }

    public static String getStringWithParam(String key, Object ... param) {
        String msg = HtmlResUtils.getString(key);
        return StringUtils.fillValues(msg, param);
    }

    public static String getOEMString(String key) {
        return HtmlResUtils.getString(key + "." + ApplicationContext.getInstance().getVender().toLowerCase(Locale.ENGLISH));
    }

    private static String getPropertiesCfg(String id) {
        return "config/" + id + "/" + DEFAULT_HTML_DIR + "/" + DEFAULT_PROPERTIES_NAME;
    }
}

