/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.certbase.integrity.CheckFileIntegrityUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneBean;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;

public class SceneUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneUtils.class);
    private static final String SCENE_SUB_SCENE_UPGRADE_NAME = "Upgrade";
    private static final String SCENE_SUB_SCENE_UPGRADE_CHECK = "Upgrade Check";
    private static final String DPA_INSPECT = "DPA Inspector";
    private static final String ENV_STEP_EXCUTED = "stepExcuted";
    private static final String SCENE_TEMPLATES = "sceneTemplates";
    private static final String TEMP = "temp";
    private static final String JSON_SCENE = "jsonScene";
    public static final String ARG_LIST = "jsonSceneArgsList";
    public static final String SETTING_STEP = "setting";
    public static final String SOFT_PACKAGE_MARK = "=3001";
    public static final String DOC_PACKAGE_MARK = "=x002";
    private static final List<String> TOOL_BOX_FOLDER = Arrays.asList("jre", "serviceConf", "lib", "doc");
    private static final String XML = ".xml";
    private static final String TEMP_XML = "_temp.xml";
    private static final String TEMP_CRL = "_temp.crl";
    private static final String TEMP_CMS = "_temp.cms";
    private static final String HUAWEI_ROOT_CA = "HuaweiRootCA.cer";
    private static final String[] NEED_CMC_VERIFY_FILE_NAMES = new String[]{"tool-box", "scene-flag", "support-products"};
    private static final List<String> SUB_SCENE_SUPPORT_ADD_VIA_SVP = Arrays.asList("PatchEvalu");
    public static final String HUAWEI_ROOT_CA_PATH = ApplicationContext.getInstance().getCurrWorkPath() + "certdir" + File.separator + "cms" + File.separator + "HuaweiRootCA.cer";
    public static final String CMS_SIGN_SUFFIX = ".p7s";
    private static final String ROOT_CA = "-----BEGIN CERTIFICATE-----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\nUCrZxwwkrbPM3H6LA3VdrF1oWN0hjg==\n-----END CERTIFICATE-----";

    public static boolean isScene() {
        String sceneKey = JSON_SCENE;
        String sceneInfo = System.getenv(sceneKey);
        return !StringUtils.isNULLStr(sceneInfo);
    }

    public static boolean isSceneStepExcuted() {
        String stepExcuted = System.getenv(ENV_STEP_EXCUTED);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The step excuted is:{}", (Object)StringUtils.getCleanMessage(stepExcuted));
        }
        return stepExcuted != null && "true".equals(stepExcuted);
    }

    public static boolean isA800SceneInTool() {
        String jsonScene = System.getenv(JSON_SCENE);
        LOGGER.info("build scene node option service, scene :{} ", (Object)jsonScene);
        if (StringUtils.isNULLStr(jsonScene)) {
            return false;
        }
        JSONObject sceneJson = new JSONObject(jsonScene);
        String field = sceneJson.getStringOrDefault("field", "");
        String subField = sceneJson.getStringOrDefault("sub_field", "");
        return "Solution".equals(field) && "INTELLIGENTCOMPUTE".equals(subField);
    }

    public static boolean isA800UpgradeCheck() {
        return Objects.equals(SceneUtils.getCurrentSubScene(), "IntelligentCompute_A800_upgrade_eval");
    }

    public static boolean isA800Inspection() {
        return Objects.equals(SceneUtils.getCurrentSubScene(), "IntelligentCompute_A800_inspection");
    }

    public static boolean isA800Upgrade() {
        return Objects.equals(SceneUtils.getCurrentSubScene(), "IntelligentCompute_A800_upgrade");
    }

    public static boolean isSpecialScence(String sceneInfo, String ... mainScences) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The scenceInfo is :" + sceneInfo);
        }
        if (StringUtils.isNULLStr(sceneInfo)) {
            return false;
        }
        for (String mainScence : mainScences) {
            if (!Normalizer.normalize(sceneInfo, Normalizer.Form.NFKC).contains(mainScence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpecialSubScence(String subSceneInfo, String ... subScences) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The subSceneInfo is :" + subSceneInfo);
        }
        if (StringUtils.isNULLStr(subSceneInfo)) {
            return false;
        }
        for (String subScence : subScences) {
            if (!subSceneInfo.equalsIgnoreCase(subScence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSceneSettingStep() {
        return SETTING_STEP.equals(SceneUtils.getParamFormArgList("toolScene"));
    }

    public static String getParamFormArgList(String key) {
        String argListStr = System.getenv(ARG_LIST);
        if (!StringUtils.isNULLStr(argListStr)) {
            try {
                JSONObject jsonObject = new JSONObject(argListStr);
                String value = jsonObject.getString(key);
                return value;
            }
            catch (JSONException e) {
                LOGGER.error("get " + key + "  failed.");
            }
            catch (RuntimeException e) {
                LOGGER.error("get " + key + "  failed.");
            }
        }
        return "";
    }

    public static String getCurrentSubScene() {
        SceneValue sceneValue = null;
        String subScene = null;
        try {
            sceneValue = (SceneValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey(JSON_SCENE);
            if (null == sceneValue) {
                return "";
            }
            subScene = sceneValue.getSubScene();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The current sub scene is:" + subScene);
            }
        }
        catch (ToolException e) {
            LOGGER.error("the sub scene exception:", (Throwable)e);
        }
        if (sceneValue == null) {
            subScene = "";
        }
        return subScene;
    }

    public static String getCurrentStepId() {
        try {
            SceneValue sceneValue = null;
            ISceneBean sceneBean = SceneEnvironmentImpl.getInstance().getEnvirValueByKey(JSON_SCENE);
            if (sceneBean instanceof SceneValue) {
                sceneValue = (SceneValue)sceneBean;
            }
            if (Objects.isNull(sceneValue)) {
                return "";
            }
            return sceneValue.getStepID();
        }
        catch (ToolException e) {
            LOGGER.error("the sub scene exception:", (Throwable)e);
            return "";
        }
    }

    public static String getExecutedSteps() {
        try {
            SceneValue sceneValue = null;
            ISceneBean sceneBean = SceneEnvironmentImpl.getInstance().getEnvirValueByKey(JSON_SCENE);
            if (sceneBean instanceof SceneValue) {
                sceneValue = (SceneValue)sceneBean;
            }
            if (Objects.isNull(sceneValue)) {
                return "";
            }
            return sceneValue.getExecutedSteps();
        }
        catch (ToolException e) {
            LOGGER.error("the sub scene exception:", (Throwable)e);
            return "";
        }
    }

    public static boolean supportAddDeviceViaSvp() {
        return SUB_SCENE_SUPPORT_ADD_VIA_SVP.contains(SceneUtils.getCurrentSubScene());
    }

    public static boolean isUpgradeSubScene() {
        return SCENE_SUB_SCENE_UPGRADE_NAME.equalsIgnoreCase(SceneUtils.getCurrentSubScene());
    }

    public static String getSceneReportPath() {
        return System.getenv("jsonSceneResultPath");
    }

    public static boolean isPreUpgradeCheckSubScene() {
        return SCENE_SUB_SCENE_UPGRADE_CHECK.equalsIgnoreCase(SceneUtils.getCurrentSubScene());
    }

    public static boolean isDpaInspect() {
        return DPA_INSPECT.equalsIgnoreCase(SceneUtils.getCurrentSubScene());
    }

    public static String getToolBoxDir() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        return SceneUtils.isToolBoxGetDir(workPath = Normalizer.normalize(workPath, Normalizer.Form.NFKC)) ? workPath : workPath.substring(0, workPath.lastIndexOf("tools"));
    }

    public static boolean isToolBoxGetDir(String path) {
        String normalizedPath = Normalizer.normalize(path, Normalizer.Form.NFKC);
        if (normalizedPath.contains("tools")) {
            File file = new File(normalizedPath);
            if (file.isDirectory()) {
                String[] fileNameString = file.list();
                if (null != fileNameString) {
                    List<String> fileNamelist = Arrays.asList(fileNameString);
                    return fileNamelist.containsAll(TOOL_BOX_FOLDER);
                }
                LOGGER.error("There is no file under this path.");
            }
            LOGGER.error("This path is not a directory.");
        }
        return true;
    }

    public static String getSceneFilePath(String fileName) {
        ApplicationContext context = ApplicationContext.getInstance();
        StringBuilder builder = new StringBuilder();
        try {
            SceneUtils.checkAndcreateSceneFolder(context);
            builder = SceneUtils.isToolBoxGetDir(context.getWorkPath()) ? builder.append(context.getWorkPath()).append(File.separator).append(TEMP).append(File.separator).append(SCENE_TEMPLATES) : builder.append(context.getWorkPath().substring(0, Normalizer.normalize(context.getWorkPath(), Normalizer.Form.NFKC).lastIndexOf("tools"))).append(TEMP).append(File.separator).append(SCENE_TEMPLATES);
            File templates = new File(builder.toString());
            if (!(templates.exists() && templates.isDirectory() || templates.mkdir())) {
                ToolLoggerFactory.getLogger(SceneUtils.class).info("Make dir error.");
            }
            builder.append(File.separator).append(fileName);
        }
        catch (Exception e) {
            LOGGER.error("sceneFilePath create failed...", (Throwable)e);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("return file path:" + builder.toString());
        }
        return builder.toString();
    }

    private static void checkAndcreateSceneFolder(ApplicationContext context) {
        File sceneFile = new File(context.getWorkPath() + File.separator + TEMP);
        if (!sceneFile.isDirectory() && LOGGER.isInfoEnabled()) {
            LOGGER.info("delete file :" + sceneFile.getName() + sceneFile.delete());
        }
        if (!sceneFile.exists() && !sceneFile.mkdir()) {
            ToolLoggerFactory.getLogger(SceneUtils.class).error("Make dir error.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSceneFileCompleteByParseXml(File file) {
        if (VerifyUtil.isEmpty(file)) {
            return false;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            boolean flag;
            boolean bl = flag = null != XmlUtils.parseDocument(fis, "utf-8");
            if (!flag) {
                LOGGER.error("scene file download error! The {} file is not completely downloaded.", (Object)file.getName());
            }
            boolean bl2 = flag;
            return bl2;
        }
        catch (IOException e) {
            LOGGER.error("file not found.", (Throwable)e);
            return false;
        }
    }

    public static boolean verifyFileByCms(String sourcePath, String signPath) {
        return CheckFileIntegrityUtils.checkFileReleaseSignByCms((String)signPath, (String)sourcePath, (byte[])ROOT_CA.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean isSceneFileComplete(File file) {
        if (VerifyUtil.isEmpty(file)) {
            return false;
        }
        String filePath = "";
        try {
            filePath = FilePathUtils.filterFilePath(file.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.error("getCanonicalPath:{} ", (Throwable)e);
        }
        if (VerifyUtil.isEmpty(filePath)) {
            return false;
        }
        String crlPath = "";
        String cmsPath = "";
        crlPath = filePath.contains(TEMP_XML) ? filePath.replace(TEMP_XML, TEMP_CRL) : filePath + TEMP_CRL;
        cmsPath = filePath.contains(TEMP_XML) ? filePath.replace(TEMP_XML, TEMP_CMS) : filePath + TEMP_CMS;
        boolean needCmsVerify = Arrays.stream(NEED_CMC_VERIFY_FILE_NAMES).anyMatch(cmsName -> file.getName().contains((CharSequence)cmsName));
        return needCmsVerify ? CheckFileIntegrityUtils.checkFileByCms((String)HUAWEI_ROOT_CA_PATH, (String)filePath, (String)crlPath, (String)cmsPath) : SceneUtils.isSceneFileCompleteByParseXml(file);
    }
}

