/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.excel;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CsvUtils {
    private static final String INVALID_SPECIAL_CHARS = "=+-&\\@";

    @NotNull
    public static String formatCsvLine(@NotNull String csvLine) {
        return Arrays.stream(csvLine.split(",")).map(CsvUtils::formatCsvCell).collect(Collectors.joining(","));
    }

    @NotNull
    public static String formatCsvCell(@NotNull String cellContent) {
        if (!CsvUtils.hasInvalidChar(cellContent) && !cellContent.contains(",")) {
            return cellContent;
        }
        String newContent = cellContent.replace("\"", "\"\"");
        if (CsvUtils.isStartswithInvalidChar(cellContent)) {
            newContent = '\t' + newContent;
        }
        return '\"' + newContent + '\"';
    }

    public static boolean isStartswithInvalidChar(@NotNull String cellContent) {
        return INVALID_SPECIAL_CHARS.indexOf(cellContent.charAt(0)) != -1;
    }

    private static boolean hasInvalidChar(String cellContent) {
        return INVALID_SPECIAL_CHARS.codePoints().anyMatch(codePoint -> cellContent.indexOf(codePoint) != -1);
    }

    private CsvUtils() {
    }
}

