/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.validate;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.validate.AbstractValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValidatorChain
extends AbstractValidator {
    private List<Validation> validations = new ArrayList<Validation>();

    public ValidatorChain() {
    }

    public ValidatorChain(Collection<AbstractValidator> validators) {
        for (AbstractValidator validator : validators) {
            this.validations.add(new Validation(validator, new Object[0]));
        }
    }

    public void append(AbstractValidator validator, Object ... params) {
        this.validations.add(new Validation(validator, params));
    }

    @Override
    public boolean validate(Object object, String objectDesc, Object ... params) {
        boolean succ = true;
        for (Validation v : this.validations) {
            Object[] vp1 = v.getParams();
            Object[] vp = params;
            if (null == vp1) {
                throw new NullPointerException();
            }
            if (vp1.length > 0) {
                vp = new Object[vp1.length + params.length];
                System.arraycopy(vp1, 0, vp, 0, vp1.length);
                System.arraycopy(params, 0, vp, vp1.length, params.length);
            }
            if (v.getValidator().validate(object, objectDesc, vp)) continue;
            succ = false;
            KeyValue<String, List<Object>> errKey = v.getValidator().getErrMsgKey();
            super.setErrMsgKey(errKey.getKey(), errKey.getValue().toArray());
            break;
        }
        return succ;
    }

    private static final class Validation {
        private AbstractValidator validator;
        private Object[] params;

        public Validation(AbstractValidator validator, Object ... params) {
            this.validator = validator;
            this.params = params;
        }

        public AbstractValidator getValidator() {
            return this.validator;
        }

        public Object[] getParams() {
            return null == this.params ? null : (Object[])this.params.clone();
        }
    }
}

