/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.common.data;

public enum ToolUserRole {
    HWENGINEER(1001, "Huawei Engineer"),
    CHANNEL(1002, "Higher Channel Engineer"),
    CUSTOMER(1003, "Customer"),
    GUEST(1004, "Guest");

    private int code;
    private String desc;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    private ToolUserRole(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ToolUserRole getRoleInfo(int code) {
        switch (code) {
            case 1001: {
                return HWENGINEER;
            }
            case 1002: {
                return CHANNEL;
            }
            case 1003: {
                return CUSTOMER;
            }
            case 1004: {
                return GUEST;
            }
        }
        return GUEST;
    }

    public static ToolUserRole getToolRoleInfo(String code) {
        String role = System.getenv("toolRunRole");
        return ToolUserRole.getRoleInfo(role != null ? role : code);
    }

    public static ToolUserRole getRoleInfo(String code) {
        int codeInt;
        if (code == null) {
            return null;
        }
        try {
            codeInt = Integer.parseInt(code);
        }
        catch (Exception e) {
            codeInt = GUEST.getCode();
        }
        return ToolUserRole.getRoleInfo(codeInt);
    }

    public static boolean isRoleCanUplaod(String code) {
        int codeInt;
        if (code == null) {
            return false;
        }
        try {
            codeInt = Integer.parseInt(code);
        }
        catch (Exception e) {
            return false;
        }
        return codeInt != CUSTOMER.getCode() && codeInt != GUEST.getCode();
    }
}

