/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.register;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.common.data.DataType;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class RegisterFunUtil {
    private static final PlatformAppContext CONTEXT = PlatformAppContext.getInstance();
    private static final String DEFAULT_PLUGIN_CONFIG = "functionCfg.properties";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RegisterFunUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFunFromConfig() {
        Properties cfg = new Properties();
        FileInputStream in = null;
        String cfgPath = CONTEXT.getRuntime().getPath(DataType.applicationCfg) + DEFAULT_PLUGIN_CONFIG;
        try {
            in = new FileInputStream(cfgPath);
            cfg.load(in);
            RegisterFunUtil.registerFunction(cfg);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found while register function");
        }
        catch (IOException e) {
            LOGGER.error("register function error");
        }
        finally {
            StreamUtils.closeResource(null, in);
        }
    }

    private static void registerFunction(Properties cfg) {
        Iterator<Map.Entry<Object, Object>> iterator = cfg.entrySet().iterator();
        HashMap<String, String> functions = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> config = iterator.next();
            String key = (String)config.getKey();
            String value = (String)config.getValue();
            functions.put(key, value);
        }
        PlatformAppContext.getInstance().setFunctionCfgs(functions);
    }
}

