/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.util;

import com.huawei.ism.tool.framework.platform.context.IPropertiesManager;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;

public class PropertiesManager
implements IPropertiesManager {
    public static final String UNMATCHED_STRING = "--";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PropertiesManager.class);
    private Map<Locale, ResourceBundle> bundleMap = new HashMap<Locale, ResourceBundle>();
    private Map<Locale, Set<String>> stringsMap = new HashMap<Locale, Set<String>>();

    public PropertiesManager(String resource, Locale[] supportedLocs, ClassLoader cl) {
        if (supportedLocs == null) {
            return;
        }
        for (Locale loc : supportedLocs) {
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(resource, loc, cl);
            }
            catch (Exception e) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Bundle " + resource + " for " + loc + " not found.");
                continue;
            }
            this.bundleMap.put(loc, bundle);
            HashSet<String> strs = new HashSet<String>();
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                strs.add(bundle.getString(keys.nextElement()));
            }
            this.stringsMap.put(loc, strs);
        }
    }

    @Override
    public Locale checkLocale(String key, String value) {
        Locale loc = Locale.getDefault();
        if (null == value) {
            return null;
        }
        for (ResourceBundle bundle : this.bundleMap.values()) {
            if (!value.equals(bundle.getObject(key))) continue;
            loc = bundle.getLocale();
            break;
        }
        return loc;
    }

    @Override
    public Set<Locale> getSupportedLocales() {
        HashSet<Locale> locales = new HashSet<Locale>();
        locales.addAll(this.bundleMap.keySet());
        return locales;
    }

    @Override
    public String getString(Locale locale, String key) {
        Locale loc = new Locale(locale.getLanguage());
        String value = UNMATCHED_STRING;
        ResourceBundle bundle = this.bundleMap.get(loc);
        if (null != bundle) {
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                LOGGER.error("Cannot find key: " + key.replace('\n', '_').replace('\r', '_'));
            }
        }
        return value;
    }

    @Override
    public String getStringWithParams(Locale loc, String key, Object ... params) {
        String value = this.getString(loc, key);
        return MessageFormat.format(value, params);
    }

    @Override
    public boolean containsString(Locale loc, String str) {
        Set<String> strs = this.stringsMap.get(loc);
        return null != strs && strs.contains(str);
    }
}

