/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.qrcodeprovide;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.qrcodeprovide.MatrixToImageWriter;
import com.huawei.ism.tool.framework.pubservice.utils.qrcodeprovide.QRCodeInputParams;
import java.io.File;
import java.text.Normalizer;
import org.slf4j.Logger;

public final class QRCodeGenerator {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QRCodeGenerator.class);
    private static QRCodeGenerator instance = null;

    private QRCodeGenerator() {
    }

    public static synchronized QRCodeGenerator getInstance() {
        if (null == instance) {
            instance = new QRCodeGenerator();
        }
        return instance;
    }

    public void createQRCodePic(QRCodeInputParams qrParams) throws ToolException {
        LOGGER.info("Start create QRCode....");
        try {
            String fullFilePath = this.checkFullPath(qrParams);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(qrParams.getUrlPath(), BarcodeFormat.QR_CODE, qrParams.getWidth(), qrParams.getHeight());
            File qrFile = new File(fullFilePath);
            MatrixToImageWriter.writeToFile(bitMatrix, qrParams.getFormat(), qrFile, qrParams.isCoverage());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Save QRCode \u201c" + fullFilePath + "\u201d successful!");
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("QRCodeGenerator getCode error.", (Throwable)e);
            throw new ToolException("QRCodeGenerator getCode error.", false, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("QRCodeGenerator getCode error.", (Throwable)e);
            throw new ToolException("QRCodeGenerator getCode error.", false, (Throwable)e);
        }
    }

    private String checkFullPath(QRCodeInputParams qrParams) throws ToolException {
        String abFolderPath = qrParams.getPath();
        if (!(abFolderPath = Normalizer.normalize(abFolderPath, Normalizer.Form.NFKC)).endsWith(File.separator)) {
            abFolderPath = abFolderPath + File.separator;
        }
        if (!new File(abFolderPath).exists()) {
            LOGGER.error("Path is error, please check.");
            throw new ToolException("Path is null or path is error, please check.", false);
        }
        String fullFolderPath = abFolderPath + qrParams.getName() + "." + qrParams.getFormat();
        if (new File(fullFolderPath).exists() && !qrParams.isCoverage()) {
            LOGGER.error("File is exists , please change the path.");
            throw new ToolException("File is exists , please change the path.", false);
        }
        return fullFolderPath;
    }
}

