/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubui;

import com.huawei.ism.tool.framework.platform.plugin.AbstractPlugin;
import com.huawei.ism.tool.framework.platform.plugin.PluginManager;
import com.huawei.ism.tool.framework.platform.pubservice.IServiceCenter;
import com.huawei.ism.tool.framework.platform.pubservice.IServiceTracker;
import com.huawei.ism.tool.framework.platform.runtime.AbstractRuntime;
import com.huawei.ism.tool.framework.pubui.common.AbstractPublicUI;
import com.huawei.ism.tool.framework.pubui.common.IPublicUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class PublicUiManage
implements IServiceCenter {
    private static PublicUiManage singleton = new PublicUiManage();
    private AbstractRuntime runtime = null;
    private boolean inited = false;
    private Map<String, IPublicUI> uisMap = new HashMap<String, IPublicUI>();
    private Map<String, List<IServiceTracker>> trackersMap = new HashMap<String, List<IServiceTracker>>();

    public static synchronized PublicUiManage getInstance() {
        return singleton;
    }

    @Override
    public void doInit(AbstractRuntime abRuntime) {
        if (this.inited) {
            return;
        }
        this.runtime = abRuntime;
        this.inited = true;
    }

    @Override
    public Collection<Class<?>> trackServices(IServiceTracker tracker, Collection<Class<?>> uisNeeded) {
        HashSet unsup = new HashSet();
        for (Class<?> uiIf : uisNeeded) {
            String uiName = uiIf.getName();
            if (!this.uisMap.containsKey(uiName)) {
                unsup.add(uiIf);
                continue;
            }
            List<IServiceTracker> trackers = this.trackersMap.get(uiName);
            if (null == trackers) {
                trackers = new ArrayList<IServiceTracker>();
                this.trackersMap.put(uiName, trackers);
            }
            trackers.add(tracker);
        }
        return unsup;
    }

    public AbstractRuntime getRuntime() {
        return this.runtime;
    }

    public boolean existsUi(Class<?> uiIf) {
        return this.uisMap.containsKey(uiIf.getName());
    }

    public void addUi(Class<?> uiIf, IPublicUI ui) {
        this.uisMap.put(uiIf.getName(), ui);
    }

    @Override
    public void registerServicePlugin(AbstractPlugin plugin) {
        if (!(plugin instanceof AbstractPublicUI)) {
            return;
        }
        AbstractPublicUI uiPlugin = (AbstractPublicUI)plugin;
        if (!uiPlugin.doInit(this.runtime)) {
            uiPlugin.registerFailed(uiPlugin.getId());
            return;
        }
        PluginManager.getInstance().savePlugin(plugin);
        for (IPublicUI ui : uiPlugin.getImplementedUIs()) {
            Class<?> uiInf = PublicUiManage.getUiInf(ui.getClass());
            if (null != uiInf && !this.existsUi(uiInf)) {
                this.addUi(uiInf, ui);
                uiPlugin.registerSuccess(uiInf.getName());
                continue;
            }
            uiPlugin.registerFailed(ui.getClass().getName());
        }
    }

    public void removeUi(Class<?> uiIf) {
        String uiName = uiIf.getName();
        this.uisMap.remove(uiName);
        List<IServiceTracker> trackers = this.trackersMap.get(uiName);
        if (null != trackers) {
            HashSet uiIfs = new HashSet();
            uiIfs.add(uiIf);
            for (IServiceTracker tracker : trackers) {
                tracker.fireServiceUnavailable(uiIfs);
            }
        }
    }

    public <T> T getUi(Class<T> uiIf) {
        String uiName = uiIf.getName();
        return (T)this.uisMap.get(uiName);
    }

    private static Class<?> getUiInf(Class<? extends IPublicUI> implClazz) {
        Class<?>[] infArr;
        Class<?> uiInf = null;
        Class<?>[] classArray = infArr = implClazz.getInterfaces();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> inf;
            Class<?> tmpInf = inf = classArray[i];
            Class<?>[] superInfs = tmpInf.getInterfaces();
            while (superInfs.length > 0 && !IPublicUI.class.equals(superInfs[0])) {
                tmpInf = superInfs[0];
                superInfs = tmpInf.getInterfaces();
            }
            if (superInfs.length <= 0 || !IPublicUI.class.equals(superInfs[0])) continue;
            uiInf = tmpInf;
            break;
        }
        return uiInf;
    }

    private PublicUiManage() {
    }
}

