/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.fusioncube.task;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.context.FusionCubeContext;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82Params;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCubeNetworkParams;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeError;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.ServiceUtils;
import com.huawei.yinglong.river.sitedeployment.fusioncube.utils.SshUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployEbackupAServiceTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployEbackupAServiceTask.class);
    public static final String TASK_NAME = "deploy.ebackup.a.service";

    public void execute() throws TaskException {
        FusionCube82Params fusionCube82Params = FusionCubeContext.getInstance().getFusionCube82Params();
        try {
            SshShellService sshShellService = SshUtils.getShellClient(fusionCube82Params.getFusionCube82VmParamsList().get(0).getManagementIp(), "root", FusionCubeContext.getInstance().getRoot());
            String result = sshShellService.execCommand(this.buildCmd(fusionCube82Params));
            if (!result.contains("Please enter password of hcp user")) {
                log.error(result);
                throw new FusionCubeException(FusionCubeError.DEPLOY_EBACKUP_A_SERVICE_ERROR);
            }
            log.info("invocation ebackup-A script");
            result = sshShellService.execCommand(fusionCube82Params.getFusionCubePasswordParams().getHcp());
            if (!result.contains("Please enter the msuser password of the backup server")) {
                log.error(result);
                throw new FusionCubeException(FusionCubeError.DEPLOY_EBACKUP_A_SERVICE_ERROR);
            }
            sshShellService.execCommand(fusionCube82Params.getFusionCubePasswordParams().getMsuser());
            ServiceUtils.checkServiceFinished(sshShellService, FusionCubeError.DEPLOY_EBACKUP_A_SERVICE_ERROR);
        }
        catch (SshException e) {
            log.error("deploy ebackup-A failed", (Throwable)e);
            throw new FusionCubeException(FusionCubeError.DEPLOY_EBACKUP_A_SERVICE_ERROR);
        }
    }

    String buildCmd(FusionCube82Params fusionCube82Params) {
        FusionCubeNetworkParams fusionCubeNetworkParams = fusionCube82Params.getFusionCubeNetworkParams();
        return String.format("sh /opt/init/ebackup_a_template_init.sh install_ebackup %s %s %s %s %s", fusionCubeNetworkParams.getManagementSegment(), fusionCubeNetworkParams.getEbackupManagementSegment(), fusionCubeNetworkParams.getStorageSegment(), fusionCubeNetworkParams.getEbackupStorageSegment(), fusionCubeNetworkParams.getEbackupFloatIpA());
    }

    @Generated
    protected DeployEbackupAServiceTask(DeployEbackupAServiceTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static DeployEbackupAServiceTaskBuilder<?, ?> builder() {
        return new DeployEbackupAServiceTaskBuilderImpl();
    }

    @Generated
    private static final class DeployEbackupAServiceTaskBuilderImpl
    extends DeployEbackupAServiceTaskBuilder<DeployEbackupAServiceTask, DeployEbackupAServiceTaskBuilderImpl> {
        @Generated
        private DeployEbackupAServiceTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DeployEbackupAServiceTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeployEbackupAServiceTask build() {
            return new DeployEbackupAServiceTask(this);
        }
    }

    @Generated
    public static abstract class DeployEbackupAServiceTaskBuilder<C extends DeployEbackupAServiceTask, B extends DeployEbackupAServiceTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DeployEbackupAServiceTask.DeployEbackupAServiceTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

