/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.fusioncube.task;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.context.FusionCubeContext;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82Params;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeError;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.ServiceUtils;
import com.huawei.yinglong.river.sitedeployment.fusioncube.utils.SshUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployEbackupBServiceTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployEbackupBServiceTask.class);
    public static final String TASK_NAME = "deploy.ebackup.b.service";

    public void execute() throws TaskException {
        try {
            FusionCube82Params fusionCube82Params = FusionCubeContext.getInstance().getFusionCube82Params();
            SshShellService sshShellService = SshUtils.getShellClient(fusionCube82Params.getFusionCube82VmParamsList().get(1).getManagementIp(), "root", FusionCubeContext.getInstance().getRoot());
            String result = sshShellService.execCommand(this.buildCmd(fusionCube82Params));
            if (!result.contains("Please enter password of hcp user")) {
                log.error(result);
                throw new FusionCubeException(FusionCubeError.DEPLOY_EBACKUP_B_SERVICE_ERROR);
            }
            log.info("invocation ebackup-B script");
            result = sshShellService.execCommand(fusionCube82Params.getFusionCubePasswordParams().getHcp());
            if (!result.contains("Please enter the msuser password of the backup server")) {
                log.error(result);
                throw new FusionCubeException(FusionCubeError.DEPLOY_EBACKUP_B_SERVICE_ERROR);
            }
            sshShellService.execCommand(fusionCube82Params.getFusionCubePasswordParams().getMsuser());
            ServiceUtils.checkServiceFinished(sshShellService, FusionCubeError.DEPLOY_EBACKUP_B_SERVICE_ERROR);
        }
        catch (SshException e) {
            log.error("deploy ebackup-A failed", (Throwable)e);
            throw new FusionCubeException(FusionCubeError.DEPLOY_EBACKUP_B_SERVICE_ERROR);
        }
    }

    private String buildCmd(FusionCube82Params fusionCube82Params) {
        return String.format("sh /opt/init/ebackup_b_template_init.sh config %s", fusionCube82Params.getFusionCubeNetworkParams().getEbackupFloatIpB());
    }

    @Generated
    protected DeployEbackupBServiceTask(DeployEbackupBServiceTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static DeployEbackupBServiceTaskBuilder<?, ?> builder() {
        return new DeployEbackupBServiceTaskBuilderImpl();
    }

    @Generated
    private static final class DeployEbackupBServiceTaskBuilderImpl
    extends DeployEbackupBServiceTaskBuilder<DeployEbackupBServiceTask, DeployEbackupBServiceTaskBuilderImpl> {
        @Generated
        private DeployEbackupBServiceTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DeployEbackupBServiceTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeployEbackupBServiceTask build() {
            return new DeployEbackupBServiceTask(this);
        }
    }

    @Generated
    public static abstract class DeployEbackupBServiceTaskBuilder<C extends DeployEbackupBServiceTask, B extends DeployEbackupBServiceTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DeployEbackupBServiceTask.DeployEbackupBServiceTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

