/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.fusioncube.task;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.AttachDiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.DiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd.EnvironmentCheckCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.batch.BatchDeployVmsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.batch.cmd.BatchDeployVmsCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcTaskService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.fusioncube.context.FusionCubeContext;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82Params;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82VmParams;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.DeployEbackupAServiceTask;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.DeployEbackupBServiceTask;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.DeployNfsAtask;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.DeployNfsBtask;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.FusionCube82xTask;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.FusionCubeMigrationVmsStatusCheckTask;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.FusionCubeResourceCleanTask;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.TemplateFileType;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.UnzipTemplateTask;
import com.huawei.yinglong.river.sitedeployment.fusioncube.utils.FusionCubeResourceBundleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public final class DeployFusionCubeTaskFactory {
    public static BaseTask createTask(FusionCube82Params fusionCube82Params) {
        BaseTask task = ((FusionCube82xTask.FusionCube82xTaskBuilder)((FusionCube82xTask.FusionCube82xTaskBuilder)((FusionCube82xTask.FusionCube82xTaskBuilder)((FusionCube82xTask.FusionCube82xTaskBuilder)((FusionCube82xTask.FusionCube82xTaskBuilder)((FusionCube82xTask.FusionCube82xTaskBuilder)((FusionCube82xTask.FusionCube82xTaskBuilder)FusionCube82xTask.builder().taskId(fusionCube82Params.getTaskId())).taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("deploy.fusion.cube.task"))).duration(FusionCubeResourceBundleUtils.getDurationFromResource("deploy.fusion.cube.task"))).taskDescription(FusionCubeResourceBundleUtils.getDescriptionFromResource("deploy.fusion.cube.task"))).subTasks(DeployFusionCubeTaskFactory.createSubtask(fusionCube82Params))).eventType("FusionCubeDeployEvent")).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).build();
        DeployFusionCubeTaskFactory.setEventType(task);
        return task;
    }

    private static void setEventType(BaseTask task) {
        task.setEventType("FusionCubeDeployEvent");
        if (CollectionUtils.isNotEmpty((Collection)task.getSubTasks())) {
            task.getSubTasks().forEach(DeployFusionCubeTaskFactory::setEventType);
        }
    }

    private static List<BaseTask> createSubtask(FusionCube82Params fusionCube82Params) {
        ArrayList<BaseTask> baseTasks = new ArrayList<BaseTask>();
        baseTasks.add(DeployFusionCubeTaskFactory.createEnvironmentTask(fusionCube82Params));
        baseTasks.add(DeployFusionCubeTaskFactory.UnzipTenmpaleteTask(fusionCube82Params));
        baseTasks.addAll(DeployFusionCubeTaskFactory.uploadFusionCubeTemplateTask(fusionCube82Params));
        baseTasks.add(DeployFusionCubeTaskFactory.createBatchVmsTask(fusionCube82Params));
        baseTasks.add(DeployFusionCubeTaskFactory.createVmCheckTask(fusionCube82Params));
        baseTasks.add(DeployFusionCubeTaskFactory.createFusionCubeResourceClean());
        baseTasks.add(DeployFusionCubeTaskFactory.createEbackupAServiceTask());
        baseTasks.add(DeployFusionCubeTaskFactory.createEbackupBServiceTask());
        baseTasks.add(DeployFusionCubeTaskFactory.createNfsAServiceTask());
        baseTasks.add(DeployFusionCubeTaskFactory.createNfsBServiceTask());
        return baseTasks;
    }

    private static BaseTask UnzipTenmpaleteTask(FusionCube82Params fusionCube82Params) {
        return ((UnzipTemplateTask.UnzipTemplateTaskBuilder)((UnzipTemplateTask.UnzipTemplateTaskBuilder)((UnzipTemplateTask.UnzipTemplateTaskBuilder)UnzipTemplateTask.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("unzip.fusion.cube.template.task"))).duration(FusionCubeResourceBundleUtils.getDurationFromResource("unzip.fusion.cube.template.task"))).taskDescription(FusionCubeResourceBundleUtils.getDescriptionFromResource("unzip.fusion.cube.template.task"))).build();
    }

    private static BaseTask createEbackupAServiceTask() {
        return ((DeployEbackupAServiceTask.DeployEbackupAServiceTaskBuilder)((DeployEbackupAServiceTask.DeployEbackupAServiceTaskBuilder)((DeployEbackupAServiceTask.DeployEbackupAServiceTaskBuilder)((DeployEbackupAServiceTask.DeployEbackupAServiceTaskBuilder)DeployEbackupAServiceTask.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("deploy.ebackup.a.service"))).duration(FusionCubeResourceBundleUtils.getDurationFromResource("deploy.ebackup.a.service"))).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).taskDescription(FusionCubeResourceBundleUtils.getDescriptionFromResource("deploy.ebackup.a.service"))).build();
    }

    private static BaseTask createEbackupBServiceTask() {
        return ((DeployEbackupBServiceTask.DeployEbackupBServiceTaskBuilder)((DeployEbackupBServiceTask.DeployEbackupBServiceTaskBuilder)((DeployEbackupBServiceTask.DeployEbackupBServiceTaskBuilder)((DeployEbackupBServiceTask.DeployEbackupBServiceTaskBuilder)DeployEbackupBServiceTask.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("deploy.ebackup.b.service"))).duration(FusionCubeResourceBundleUtils.getDurationFromResource("deploy.ebackup.b.service"))).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).taskDescription(FusionCubeResourceBundleUtils.getDescriptionFromResource("deploy.ebackup.b.service"))).build();
    }

    private static BaseTask createNfsAServiceTask() {
        return ((DeployNfsAtask.DeployNfsAtaskBuilder)((DeployNfsAtask.DeployNfsAtaskBuilder)((DeployNfsAtask.DeployNfsAtaskBuilder)((DeployNfsAtask.DeployNfsAtaskBuilder)DeployNfsAtask.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("deploy.nfs.a.task"))).duration(FusionCubeResourceBundleUtils.getDurationFromResource("deploy.nfs.a.task"))).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).taskDescription(FusionCubeResourceBundleUtils.getDescriptionFromResource("deploy.nfs.a.task"))).build();
    }

    private static BaseTask createNfsBServiceTask() {
        return ((DeployNfsBtask.DeployNfsBtaskBuilder)((DeployNfsBtask.DeployNfsBtaskBuilder)((DeployNfsBtask.DeployNfsBtaskBuilder)DeployNfsBtask.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("deploy.nfs.b.task"))).duration(FusionCubeResourceBundleUtils.getDurationFromResource("deploy.nfs.b.task"))).taskDescription(FusionCubeResourceBundleUtils.getDescriptionFromResource("deploy.nfs.b.task"))).build();
    }

    private static BaseTask createFusionCubeResourceClean() {
        return ((FusionCubeResourceCleanTask.FusionCubeResourceCleanTaskBuilder)((FusionCubeResourceCleanTask.FusionCubeResourceCleanTaskBuilder)((FusionCubeResourceCleanTask.FusionCubeResourceCleanTaskBuilder)FusionCubeResourceCleanTask.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("deploy.campus.template.clean"))).duration(FusionCubeResourceBundleUtils.getDurationFromResource("deploy.campus.template.clean"))).taskDescription(FusionCubeResourceBundleUtils.getDescriptionFromResource("deploy.campus.template.clean"))).build();
    }

    private static BaseTask createVmCheckTask(FusionCube82Params fusionCube82Params) {
        return ((FusionCubeMigrationVmsStatusCheckTask.FusionCubeMigrationVmsStatusCheckTaskBuilder)((FusionCubeMigrationVmsStatusCheckTask.FusionCubeMigrationVmsStatusCheckTaskBuilder)((FusionCubeMigrationVmsStatusCheckTask.FusionCubeMigrationVmsStatusCheckTaskBuilder)FusionCubeMigrationVmsStatusCheckTask.builder().fusionCube82VmParams(fusionCube82Params.getFusionCube82VmParamsList()).taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("deploy.fusion.cube.vm.status.check"))).duration(FusionCubeResourceBundleUtils.getDurationFromResource("deploy.fusion.cube.vm.status.check"))).taskDescription(FusionCubeResourceBundleUtils.getDescriptionFromResource("deploy.fusion.cube.vm.status.check"))).build();
    }

    private static BaseTask createBatchVmsTask(FusionCube82Params fusionCube82Params) {
        BatchDeployVmsTask batchDeployVmsTask = FcTaskService.createBatchDeployVmsTask(DeployFusionCubeTaskFactory.buildBatchCreateVmsCmd(fusionCube82Params), (FcLoginInfo)FusionCubeContext.getInstance().getFcLoginInfo());
        batchDeployVmsTask.setSupportOperates(Collections.singletonList(TaskOperateEnum.RETRY));
        batchDeployVmsTask.setEventType("FusionCubeDeployEvent");
        return batchDeployVmsTask;
    }

    private static List<BatchDeployVmsCmd> buildBatchCreateVmsCmd(FusionCube82Params fusionCube82Params) {
        return fusionCube82Params.getFusionCube82VmParamsList().stream().map(fusionCube82VmParams -> DeployFusionCubeTaskFactory.buildVmsCmd(fusionCube82VmParams)).collect(Collectors.toList());
    }

    private static BatchDeployVmsCmd buildVmsCmd(FusionCube82VmParams fusionCube82Params) {
        return BatchDeployVmsCmd.builder().isBindHost(true).cnaName(fusionCube82Params.getCna()).createVmByTemplateCmdSupplier(() -> DeployFusionCubeTaskFactory.createVmCmd(fusionCube82Params)).attachDiskCmdSupplier(() -> DeployFusionCubeTaskFactory.createDiskCmd(fusionCube82Params)).build();
    }

    private static AttachDiskCmd createDiskCmd(FusionCube82VmParams fusionCube82Params) {
        return AttachDiskCmd.builder().vmId(() -> TaskContext.get().getVmId()).hostName(fusionCube82Params.getVmName()).diskCmds(DeployFusionCubeTaskFactory.buildDiskCmd(fusionCube82Params)).build();
    }

    private static List<DiskCmd> buildDiskCmd(FusionCube82VmParams fusionCube82Params) {
        if (fusionCube82Params.getVmName().contains("eBackup")) {
            return Collections.emptyList();
        }
        return Collections.singletonList(DiskCmd.builder().dateStoreName(fusionCube82Params.getStorageName()).quantityGB(Integer.valueOf(fusionCube82Params.getDataDisk()).intValue()).build());
    }

    private static CreateVmByTemplateCmd createVmCmd(FusionCube82VmParams fusionCube82VmParams) {
        return ((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)CreateVmByTemplateCmd.builder().taskName(fusionCube82VmParams.getVmName())).password(FusionCubeContext.getInstance().getRoot()).hostName(fusionCube82VmParams.getVmName()).nicConfigs(DeployFusionCubeTaskFactory.buildNicConfigs(fusionCube82VmParams)).cnaName(fusionCube82VmParams.getCna())).vmName(fusionCube82VmParams.getVmName())).cpuCores(Integer.valueOf(fusionCube82VmParams.getCpu()).intValue())).datastoreName(fusionCube82VmParams.getStorageName())).memorySizeGb(Integer.valueOf(fusionCube82VmParams.getMemory()).intValue())).templateId(() -> DeployFusionCubeTaskFactory.getTempalteId(fusionCube82VmParams)).vmIdHandler(vmId -> DeployFusionCubeTaskFactory.setVmId(fusionCube82VmParams, vmId))).isAutoStartVm(false)).build();
    }

    private static void setVmId(FusionCube82VmParams fusionCube82VmParams, String vmId) {
        if ("eBackup-A".equals(fusionCube82VmParams.getVmName())) {
            FusionCubeContext.getInstance().setEbackupAvmId(vmId);
        } else if ("eBackup-B".equals(fusionCube82VmParams.getVmName())) {
            FusionCubeContext.getInstance().setEbackupBvmId(vmId);
        } else if ("nfs-A".equals(fusionCube82VmParams.getVmName())) {
            FusionCubeContext.getInstance().setNfsAvmId(vmId);
        } else {
            FusionCubeContext.getInstance().setNfsBvmId(vmId);
        }
    }

    private static String getTempalteId(FusionCube82VmParams fusionCube82VmParams) {
        if ("eBackup-A".equals(fusionCube82VmParams.getVmName())) {
            return FusionCubeContext.getInstance().getEbackupAtemplateId();
        }
        if ("eBackup-B".equals(fusionCube82VmParams.getVmName())) {
            return FusionCubeContext.getInstance().getEbackUpBtemplateId();
        }
        return FusionCubeContext.getInstance().getNfsTemplateId();
    }

    private static List<VmNicConfigCmd> buildNicConfigs(FusionCube82VmParams fusionCube82VmParams) {
        ArrayList<VmNicConfigCmd> vmNicConfigCmds = new ArrayList<VmNicConfigCmd>();
        VmNicConfigCmd management = VmNicConfigCmd.builder().ip(fusionCube82VmParams.getManagementIp()).gateway(FusionCubeContext.getInstance().getGateway()).netmask(FusionCubeContext.getInstance().getMask()).portGroupName(FusionCubeContext.getInstance().getPortGroup()).build();
        vmNicConfigCmds.add(management);
        if (DeployFusionCubeTaskFactory.isEbackUpVm(fusionCube82VmParams)) {
            VmNicConfigCmd productionStorage = VmNicConfigCmd.builder().ip(fusionCube82VmParams.getProductionStorageIp()).netmask(fusionCube82VmParams.getProductionStorageMask()).portGroupName(fusionCube82VmParams.getProductionStoragePortGroup()).build();
            vmNicConfigCmds.add(productionStorage);
        }
        VmNicConfigCmd backupStorage = VmNicConfigCmd.builder().ip(fusionCube82VmParams.getBackupStorageIp()).netmask(fusionCube82VmParams.getBackupStoragePortMask()).portGroupName(fusionCube82VmParams.getBackupStoragePortGroup()).build();
        vmNicConfigCmds.add(backupStorage);
        return vmNicConfigCmds;
    }

    private static boolean isEbackUpVm(FusionCube82VmParams fusionCube82VmParams) {
        return "eBackup-A".equals(fusionCube82VmParams.getVmName()) || "eBackup-B".equals(fusionCube82VmParams.getVmName());
    }

    private static List<BaseTask> uploadFusionCubeTemplateTask(FusionCube82Params fusionCube82Params) {
        ArrayList<BaseTask> baseTasks = new ArrayList<BaseTask>();
        baseTasks.add(DeployFusionCubeTaskFactory.createEbackupAuploadTaskCmd(fusionCube82Params));
        baseTasks.add(DeployFusionCubeTaskFactory.createEbackupBuploadTaskCmd(fusionCube82Params));
        baseTasks.add(DeployFusionCubeTaskFactory.createNfsAuploadTaskCmd(fusionCube82Params));
        return baseTasks;
    }

    private static BaseTask createNfsAuploadTaskCmd(FusionCube82Params fusionCube82Params) {
        return FcTaskService.uploadTemplateTask(() -> DeployFusionCubeTaskFactory.buildNfsUploadTemplateCmd(fusionCube82Params), (FcLoginInfo)FusionCubeContext.getInstance().getFcLoginInfo());
    }

    private static UploadTemplateCmd buildNfsUploadTemplateCmd(FusionCube82Params fusionCube82Params) {
        FusionCube82VmParams vmInfo = fusionCube82Params.getFusionCube82VmParamsList().get(2);
        return UploadTemplateCmd.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("upload.nfs.template")).cnaName(vmInfo.getCna()).datastoreName(vmInfo.getStorageName()).filePath(() -> DeployFusionCubeTaskFactory.getTemplateFilepath(TemplateFileType.NFS_VHD)).ovfFilePath(() -> DeployFusionCubeTaskFactory.getTemplateFilepath(TemplateFileType.NFS_OVF)).templateIdHandler(templateId -> FusionCubeContext.getInstance().setNfsTemplateId((String)templateId)).templateName(vmInfo.getVmName()).build();
    }

    private static BaseTask createEbackupBuploadTaskCmd(FusionCube82Params fusionCube82Params) {
        return FcTaskService.uploadTemplateTask(() -> DeployFusionCubeTaskFactory.buildEbackupBUploadTemplateCmd(fusionCube82Params), (FcLoginInfo)FusionCubeContext.getInstance().getFcLoginInfo());
    }

    private static UploadTemplateCmd buildEbackupBUploadTemplateCmd(FusionCube82Params fusionCube82Params) {
        FusionCube82VmParams vmInfo = fusionCube82Params.getFusionCube82VmParamsList().get(1);
        return UploadTemplateCmd.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("upload.ebackup.b.template")).cnaName(vmInfo.getCna()).datastoreName(vmInfo.getStorageName()).filePath(() -> DeployFusionCubeTaskFactory.getTemplateFilepath(TemplateFileType.EBACKUP_B_VHD)).ovfFilePath(() -> DeployFusionCubeTaskFactory.getTemplateFilepath(TemplateFileType.EBACKUP_B_OVF)).templateIdHandler(templateId -> FusionCubeContext.getInstance().setEbackUpBtemplateId((String)templateId)).templateName(vmInfo.getVmName()).build();
    }

    private static BaseTask createEbackupAuploadTaskCmd(FusionCube82Params fusionCube82Params) {
        return FcTaskService.uploadTemplateTask(() -> DeployFusionCubeTaskFactory.buildEbackupAUploadTemplateCmd(fusionCube82Params), (FcLoginInfo)FusionCubeContext.getInstance().getFcLoginInfo());
    }

    private static UploadTemplateCmd buildEbackupAUploadTemplateCmd(FusionCube82Params fusionCube82Params) {
        FusionCube82VmParams vmInfo = fusionCube82Params.getFusionCube82VmParamsList().get(0);
        return UploadTemplateCmd.builder().taskName(FusionCubeResourceBundleUtils.getTaskNameFromResource("upload.ebackup.a.template")).cnaName(vmInfo.getCna()).datastoreName(vmInfo.getStorageName()).filePath(() -> DeployFusionCubeTaskFactory.getTemplateFilepath(TemplateFileType.EBACKUP_A_VHD)).ovfFilePath(() -> DeployFusionCubeTaskFactory.getTemplateFilepath(TemplateFileType.EBACKUP_A_OVF)).templateIdHandler(templateId -> FusionCubeContext.getInstance().setEbackupAtemplateId((String)templateId)).templateName(vmInfo.getVmName()).build();
    }

    private static String getTemplateFilepath(TemplateFileType templateFileType) {
        String filepath = "";
        String templateCache = FusionCubeContext.getInstance().getTemplateCache();
        switch (templateFileType) {
            case EBACKUP_A_VHD: {
                filepath = FilePathValidatorUtils.joinChildPath((String[])new String[]{templateCache, "eBackup-A-template", "eBackup-A-template-vda.vhd"});
                break;
            }
            case EBACKUP_A_OVF: {
                filepath = FilePathValidatorUtils.joinChildPath((String[])new String[]{templateCache, "eBackup-A-template", "eBackup-A-template.ovf"});
                break;
            }
            case EBACKUP_B_VHD: {
                filepath = FilePathValidatorUtils.joinChildPath((String[])new String[]{templateCache, "eBackup-B-template", "eBackup-B-template-vda.vhd"});
                break;
            }
            case EBACKUP_B_OVF: {
                filepath = FilePathValidatorUtils.joinChildPath((String[])new String[]{templateCache, "eBackup-B-template", "eBackup-B-template.ovf"});
                break;
            }
            case NFS_VHD: {
                filepath = FilePathValidatorUtils.joinChildPath((String[])new String[]{templateCache, "nfs-template", "nfs-template-vda.vhd"});
                break;
            }
            case NFS_OVF: {
                filepath = FilePathValidatorUtils.joinChildPath((String[])new String[]{templateCache, "nfs-template", "nfs-template.ovf"});
                break;
            }
        }
        return filepath;
    }

    private static BaseTask createEnvironmentTask(FusionCube82Params fusionCube82Params) {
        return FcTaskService.createEnvironmentCheckTask((EnvironmentCheckCmd)DeployFusionCubeTaskFactory.buildEnvironmentCmd(fusionCube82Params), (FcLoginInfo)FusionCubeContext.getInstance().getFcLoginInfo());
    }

    static EnvironmentCheckCmd buildEnvironmentCmd(FusionCube82Params fusionCube82Params) {
        EnvironmentCheckCmd environmentCheckCmd = EnvironmentCheckCmd.builder().cpuMagnification(1).oldVmIds(DeployFusionCubeTaskFactory::getOldVmId).build();
        fusionCube82Params.getFusionCube82VmParamsList().forEach(fusionCube82VmParams -> DeployFusionCubeTaskFactory.addEnviromentData(environmentCheckCmd, fusionCube82VmParams));
        return environmentCheckCmd;
    }

    private static void addEnviromentData(EnvironmentCheckCmd environmentCheckCmd, FusionCube82VmParams fusionCube82VmParams) {
        environmentCheckCmd.addMemory(fusionCube82VmParams.getCna(), Integer.parseInt(fusionCube82VmParams.getMemory()));
        environmentCheckCmd.addCpu(fusionCube82VmParams.getCna(), Integer.parseInt(fusionCube82VmParams.getCpu()));
        environmentCheckCmd.addDatastore(fusionCube82VmParams.getStorageName(), DeployFusionCubeTaskFactory.getDiskSize(fusionCube82VmParams));
    }

    private static int getDiskSize(FusionCube82VmParams fusionCube82VmParams) {
        String dataDisk = fusionCube82VmParams.getDataDisk();
        return StringUtils.isEmpty((CharSequence)dataDisk) ? 0 : Integer.parseInt(dataDisk) + Integer.parseInt(fusionCube82VmParams.getSystemDisk());
    }

    static List<String> getOldVmId() {
        ArrayList<String> vms = new ArrayList<String>();
        FusionCubeContext instance = FusionCubeContext.getInstance();
        if (StringUtils.isNotEmpty((CharSequence)instance.getEbackupAvmId())) {
            vms.add(instance.getEbackupAvmId());
        }
        if (StringUtils.isNotEmpty((CharSequence)instance.getEbackupBvmId())) {
            vms.add(instance.getEbackupBvmId());
        }
        if (StringUtils.isNotEmpty((CharSequence)instance.getNfsAvmId())) {
            vms.add(instance.getNfsAvmId());
        }
        if (StringUtils.isNotEmpty((CharSequence)instance.getNfsBvmId())) {
            vms.add(instance.getNfsBvmId());
        }
        return vms;
    }

    @Generated
    private DeployFusionCubeTaskFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

