/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.fusioncube.task;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.context.FusionCubeContext;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82Params;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeError;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.ServiceUtils;
import com.huawei.yinglong.river.sitedeployment.fusioncube.utils.SshUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployNfsAtask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployNfsAtask.class);
    public static final String TASK_NAME = "deploy.nfs.a.task";

    public void execute() throws TaskException {
        String diskName = ServiceUtils.getDiskName(FusionCubeContext.getInstance().getNfsAvmId());
        FusionCube82Params fusionCube82Params = FusionCubeContext.getInstance().getFusionCube82Params();
        try {
            SshShellService sshShellService = SshUtils.getShellClient(fusionCube82Params.getFusionCube82VmParamsList().get(2).getManagementIp(), "root", FusionCubeContext.getInstance().getRoot());
            String result = sshShellService.execCommand(this.buildCmd(fusionCube82Params, diskName));
            if (!result.contains("Please enter password of hcp user")) {
                log.error(result);
                throw new FusionCubeException(FusionCubeError.DEPLOY_NFS_A_SERVICE_ERROR);
            }
            log.info("invocation nfs-A script");
            sshShellService.execCommand(fusionCube82Params.getFusionCubePasswordParams().getHcp());
            ServiceUtils.checkServiceFinished(sshShellService, FusionCubeError.DEPLOY_NFS_A_SERVICE_ERROR);
        }
        catch (SshException e) {
            log.error("deploy nfs-A failed", (Throwable)e);
            throw new FusionCubeException(FusionCubeError.DEPLOY_NFS_A_SERVICE_ERROR);
        }
    }

    private String buildCmd(FusionCube82Params fusionCube82Params, String diskName) {
        return String.format("sh /opt/init/nfs_template_init.sh install_nfs %s %s ", diskName, fusionCube82Params.getFusionCube82VmParamsList().get(0).getBackupStorageIp());
    }

    @Generated
    protected DeployNfsAtask(DeployNfsAtaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static DeployNfsAtaskBuilder<?, ?> builder() {
        return new DeployNfsAtaskBuilderImpl();
    }

    @Generated
    private static final class DeployNfsAtaskBuilderImpl
    extends DeployNfsAtaskBuilder<DeployNfsAtask, DeployNfsAtaskBuilderImpl> {
        @Generated
        private DeployNfsAtaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DeployNfsAtaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeployNfsAtask build() {
            return new DeployNfsAtask(this);
        }
    }

    @Generated
    public static abstract class DeployNfsAtaskBuilder<C extends DeployNfsAtask, B extends DeployNfsAtaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DeployNfsAtask.DeployNfsAtaskBuilder(super=" + super.toString() + ")";
        }
    }
}

