/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.fusioncube.task;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.context.FusionCubeContext;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82Params;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeError;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.ServiceUtils;
import com.huawei.yinglong.river.sitedeployment.fusioncube.utils.SshUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployNfsBtask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployNfsBtask.class);
    public static final String TASK_NAME = "deploy.nfs.b.task";

    public void execute() throws TaskException {
        String diskName = ServiceUtils.getDiskName(FusionCubeContext.getInstance().getNfsBvmId());
        FusionCube82Params fusionCube82Params = FusionCubeContext.getInstance().getFusionCube82Params();
        try {
            SshShellService sshShellService = SshUtils.getShellClient(fusionCube82Params.getFusionCube82VmParamsList().get(3).getManagementIp(), "root", FusionCubeContext.getInstance().getRoot());
            String result = sshShellService.execCommand(this.buildCmd(fusionCube82Params, diskName));
            if (!result.contains("Please enter password of hcp user")) {
                log.error(result);
                throw new FusionCubeException(FusionCubeError.DEPLOY_NFS_B_SERVICE_ERROR);
            }
            log.info("invocation nfs-B script");
            sshShellService.execCommand(fusionCube82Params.getFusionCubePasswordParams().getHcp());
            ServiceUtils.checkServiceFinished(sshShellService, FusionCubeError.DEPLOY_NFS_B_SERVICE_ERROR);
        }
        catch (SshException e) {
            log.error("deploy nfs-B failed", (Throwable)e);
            throw new FusionCubeException(FusionCubeError.DEPLOY_NFS_B_SERVICE_ERROR);
        }
    }

    public void afterExecute() {
        FusionCubeContext.getInstance().clearVmId();
    }

    private String buildCmd(FusionCube82Params fusionCube82Params, String diskName) {
        return String.format("sh /opt/init/nfs_template_init.sh install_nfs %s %s ", diskName, fusionCube82Params.getFusionCube82VmParamsList().get(1).getBackupStorageIp());
    }

    @Generated
    protected DeployNfsBtask(DeployNfsBtaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static DeployNfsBtaskBuilder<?, ?> builder() {
        return new DeployNfsBtaskBuilderImpl();
    }

    @Generated
    private static final class DeployNfsBtaskBuilderImpl
    extends DeployNfsBtaskBuilder<DeployNfsBtask, DeployNfsBtaskBuilderImpl> {
        @Generated
        private DeployNfsBtaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DeployNfsBtaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeployNfsBtask build() {
            return new DeployNfsBtask(this);
        }
    }

    @Generated
    public static abstract class DeployNfsBtaskBuilder<C extends DeployNfsBtask, B extends DeployNfsBtaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DeployNfsBtask.DeployNfsBtaskBuilder(super=" + super.toString() + ")";
        }
    }
}

