/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.fusioncube.task;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.context.FusionCubeContext;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeError;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeException;
import com.huawei.yinglong.river.sitedeployment.fusioncube.task.ResultType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);

    public static String getDiskName(String vmId) {
        ApiClient apiClient = FcClientService.createApiService((FcLoginInfo)FusionCubeContext.getInstance().getFcLoginInfo());
        VmDetail vmDetail = apiClient.getVmDetail(vmId);
        List disks = vmDetail.getVmConfig().getDisks();
        if (CollectionUtils.isEmpty((Collection)disks)) {
            throw new FusionCubeException(FusionCubeError.DEPLOY_NFS_A_SERVICE_ERROR);
        }
        return disks.stream().filter(disk -> !disk.isSystemVolume()).findFirst().orElseThrow(() -> new FusionCubeException(FusionCubeError.UNKNOWN_ERROR)).getDevName();
    }

    public static void checkServiceFinished(SshShellService sshShellService, FusionCubeError error) {
        try {
            RetryUtils.retry(() -> ServiceUtils.isEbackupAserviceFinished(sshShellService, error), (int)10, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (TaskException e) {
            log.error("execute time out", (Throwable)e);
            throw new FusionCubeException(error);
        }
    }

    private static Boolean isEbackupAserviceFinished(SshShellService sshShellService, FusionCubeError error) {
        try {
            String result = sshShellService.execCommand("cat /opt/init/result.log");
            return ServiceUtils.checkDeployDetail(result, error);
        }
        catch (SshException e) {
            throw new FusionCubeException(error);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Boolean checkDeployDetail(String result, FusionCubeError error) {
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(result));){
            List serviceInfos = bufferedReader.lines().filter(line -> line.contains("Init")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(serviceInfos)) {
                Boolean bl = false;
                return bl;
            }
            String currentResult = (String)serviceInfos.get(serviceInfos.size() - 1);
            if (currentResult.split("\\|\\|").length != 3) {
                log.error("The command output is invalid.");
                throw new FusionCubeException(error);
            }
            if (currentResult.contains(ResultType.SUCCESS.getType())) {
                Boolean bl = true;
                return bl;
            }
            if (currentResult.contains(ResultType.RUNNING.getType())) {
                Boolean bl = false;
                return bl;
            }
            if (!currentResult.contains(ResultType.ERROR.getType())) return false;
            log.error("deploy service error");
            throw new FusionCubeException(error);
        }
        catch (IOException e) {
            log.error("release resource error.", (Throwable)e);
            throw new FusionCubeException(error);
        }
    }

    @Generated
    private ServiceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

