/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.fusioncube.task;

import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.fusioncube.constant.FusionCubeMigrationConstant;
import com.huawei.yinglong.river.sitedeployment.fusioncube.context.FusionCubeContext;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeError;
import com.huawei.yinglong.river.sitedeployment.fusioncube.exception.FusionCubeException;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipTemplateTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnzipTemplateTask.class);
    public static final String TASK_NAME = "unzip.fusion.cube.template.task";
    private static final Pattern TEMPLATE_FILE_PATTERN = Pattern.compile("^FusionCube_.*?_MigrationTemplate\\.zip$");

    public void execute() throws TaskException {
        ZipUtils.decompressFileBy7Zip((String)FusionCubeMigrationConstant.ZIP_TOOL_PATH, (String)this.getFusionCubeMigrationSourceFile(), (String)this.getFusionCubeMigrationTargetFile());
    }

    private String getFusionCubeMigrationTargetFile() {
        String templateCache = FilePathValidatorUtils.joinChildPath((String[])new String[]{FusionCubeMigrationConstant.TEMPORARY_CACHE, StringUtils.commonFormatTimeText()});
        File file = new File(templateCache);
        if (!file.exists() && !file.mkdirs()) {
            log.error("TempCachePath create error");
            throw new FusionCubeException(FusionCubeError.UNKNOWN_ERROR);
        }
        FusionCubeContext.getInstance().setTemplateCache(templateCache);
        return templateCache;
    }

    private String getFusionCubeMigrationSourceFile() {
        String filePath = FusionCubeContext.getInstance().getFusionCube82Params().getFusionCubeBaseParams().getFilePath();
        File files = new File(filePath);
        File targetFile = Arrays.stream((Object[])Objects.requireNonNull(files.listFiles())).filter(file -> TEMPLATE_FILE_PATTERN.matcher(file.getName()).find()).findFirst().orElseThrow(() -> new FusionCubeException(FusionCubeError.UNKNOWN_ERROR));
        return (String)FilePathValidatorUtils.getSafePath((File)targetFile).orElseThrow(() -> new FusionCubeException(FusionCubeError.UNKNOWN_ERROR));
    }

    @Generated
    protected UnzipTemplateTask(UnzipTemplateTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static UnzipTemplateTaskBuilder<?, ?> builder() {
        return new UnzipTemplateTaskBuilderImpl();
    }

    @Generated
    private static final class UnzipTemplateTaskBuilderImpl
    extends UnzipTemplateTaskBuilder<UnzipTemplateTask, UnzipTemplateTaskBuilderImpl> {
        @Generated
        private UnzipTemplateTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UnzipTemplateTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UnzipTemplateTask build() {
            return new UnzipTemplateTask(this);
        }
    }

    @Generated
    public static abstract class UnzipTemplateTaskBuilder<C extends UnzipTemplateTask, B extends UnzipTemplateTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UnzipTemplateTask.UnzipTemplateTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

