/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cms.verify.bc;

import com.huawei.cms.verify.bc.CertWrapper;
import com.huawei.cms.verify.bc.CmsValidationException;
import com.huawei.cms.verify.bc.CmscbbErr;
import com.huawei.cms.verify.bc.CommonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class CertPath {
    private final CertWrapper trustAnchor;
    private final List<CertWrapper> intermediates;
    private final CertWrapper target;
    private final boolean targetIsTrustAnchor;

    public CertPath(CertWrapper target, CertWrapper trustAnchor, List<CertWrapper> intermediates) {
        CommonUtil.requireNonNull(target, "target");
        CommonUtil.requireNonNull(trustAnchor, "trustAnchor");
        this.target = target;
        this.trustAnchor = trustAnchor;
        this.targetIsTrustAnchor = target.equals(trustAnchor);
        this.intermediates = this.targetIsTrustAnchor || intermediates == null ? Collections.emptyList() : Collections.unmodifiableList(intermediates);
    }

    public CertWrapper getTrustAnchor() {
        return this.trustAnchor;
    }

    public List<CertWrapper> getIntermediates() {
        return this.intermediates;
    }

    public List<CertWrapper> getAllCert() throws CmsValidationException {
        ArrayList<CertWrapper> allCert = new ArrayList<CertWrapper>();
        for (CertWrapper m : this.intermediates) {
            CmscbbErr sigVerification = m.getSigVerification();
            if (sigVerification == null || sigVerification == CmscbbErr.OK) continue;
            throw new CmsValidationException(sigVerification);
        }
        allCert.add(this.target);
        allCert.addAll(this.intermediates);
        allCert.add(this.trustAnchor);
        return allCert;
    }

    public CertWrapper getTarget() {
        return this.target;
    }

    public boolean getTargetIsTrustAnchor() {
        return this.targetIsTrustAnchor;
    }

    public int hashCode() {
        int hc = this.target.hashCode();
        hc = 31 * hc + this.target.hashCode();
        hc = 31 * hc + this.intermediates.hashCode();
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CertPath)) {
            return false;
        }
        CertPath oth = (CertPath)obj;
        return this.target.equals(oth.target) && this.trustAnchor.equals(oth.trustAnchor) && this.intermediates.equals(oth.intermediates);
    }

    public CertPath certPathOfIssuer() {
        if (this.intermediates.isEmpty()) {
            return new CertPath(this.trustAnchor, this.trustAnchor, null);
        }
        CertWrapper issuer = this.intermediates.get(0);
        LinkedList<CertWrapper> newIntermediates = new LinkedList<CertWrapper>();
        for (int i = 1; i < this.intermediates.size(); ++i) {
            newIntermediates.add(this.intermediates.get(i));
        }
        return new CertPath(issuer, this.trustAnchor, newIntermediates);
    }

    public boolean getSigVerification() throws CmsValidationException {
        if (this.targetIsTrustAnchor) {
            return true;
        }
        CmscbbErr targetRes = this.target.getSigVerification();
        this.checkResIsError(targetRes);
        if (targetRes == null) {
            return false;
        }
        for (CertWrapper m : this.intermediates) {
            CmscbbErr medRes = m.getSigVerification();
            this.checkResIsError(medRes);
            if (medRes != null) continue;
            return false;
        }
        return true;
    }

    private void checkResIsError(CmscbbErr res) throws CmsValidationException {
        if (res != null && res != CmscbbErr.OK) {
            throw new CmsValidationException(res);
        }
    }

    public boolean getStatusVerification() throws CmsValidationException {
        if (this.targetIsTrustAnchor) {
            return true;
        }
        CmscbbErr targetRes = this.target.getStatusVerification();
        this.checkResIsError(targetRes);
        if (targetRes == null) {
            return false;
        }
        for (CertWrapper m : this.intermediates) {
            CmscbbErr medRes = m.getStatusVerification();
            this.checkResIsError(medRes);
            if (medRes != null) continue;
            return false;
        }
        return true;
    }

    public CertWrapper getIssuerOfTarget() {
        return this.intermediates.isEmpty() ? this.trustAnchor : this.intermediates.get(0);
    }
}

