/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.ssl;

import com.huawei.ism.tool.certbase.utils.RevokedCertUtil;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySslX509TrustManager
implements X509TrustManager {
    private static final Logger log = LoggerFactory.getLogger(MySslX509TrustManager.class);
    private final X509TrustManager trustManager;

    public MySslX509TrustManager(X509TrustManager wrappedTrustManager) {
        this.trustManager = wrappedTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] ax509certificate, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (null == chain || chain.length < 1) {
            throw new CertificateException("checkServerTrusted:X509Certificate chain array is null or empty.");
        }
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.printCertificateChain(chain);
            throw e;
        }
        if (!RevokedCertUtil.verifyCrl(RevokedCertUtil.getX509Crl(), (Certificate[])chain)) {
            throw new CertificateException("checkServerTrusted: server cert is revoked.");
        }
    }

    private void printCertificateChain(X509Certificate[] chain) throws CertificateException {
        try {
            for (X509Certificate x509Certificate : chain) {
                log.warn("verify failed, the server chain info,issuer:{} and subject:{}", (Object)x509Certificate.getIssuerDN().getName(), (Object)x509Certificate.getSubjectDN().getName());
            }
        }
        catch (Exception e) {
            throw new CertificateException("printCertificateChain error", e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

