/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.context;

import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuDeployTaskDetailResult;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuVmsParams;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DeployDayuVmsParamsEntity;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuError;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.AttachDiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class DeployDayuContext {
    private final Map<String, CreateVmByTemplateCmd> createVmByTemplateCmdMap = new HashMap<String, CreateVmByTemplateCmd>();
    private final Map<String, AttachDiskCmd> attachDiskCmdMap = new HashMap<String, AttachDiskCmd>();
    private final Map<String, String> hostNameMapToVmId = new HashMap<String, String>();
    private DayuVmsParams dayuVmsParams;
    private String deployServiceState;
    private String scriptError;
    private String eDataInsightVmId;
    private String dayuTemplateVhd;
    private String dayuTemplateOvf;
    private String unzipTemplateFilePath;
    private String deployDayuVmsTaskId;
    private String deployDayuServiceTaskId;
    private String executeDayuServiceScriptTaskId;
    private DayuDeployTaskDetailResult dayuDeployTaskDetailResult;
    private long timeDeltaOfLocalToVm = Long.MIN_VALUE;

    public static DeployDayuContext getInstance() {
        return DeployDayuVmsContextHolder.INSTANCE;
    }

    public List<String> getDeployedVmId() {
        if (CollectionUtils.isEmpty(this.hostNameMapToVmId.keySet())) {
            return Collections.emptyList();
        }
        return this.hostNameMapToVmId.keySet().stream().map(this.hostNameMapToVmId::get).collect(Collectors.toList());
    }

    public void setDayuVmsParams(DayuVmsParams dayuVmsParams) {
        this.attachDiskCmdMap.clear();
        this.createVmByTemplateCmdMap.clear();
        this.dayuVmsParams = dayuVmsParams;
        this.setVmsParams(dayuVmsParams);
    }

    public String getCloudSopIp() {
        return Optional.of(this.dayuVmsParams.getDeployDayuVmsParamsEntities()).filter(CollectionUtils::isNotEmpty).map(entities -> ((DeployDayuVmsParamsEntity)entities.get(0)).getNicConfigs()).filter(CollectionUtils::isNotEmpty).map(nic -> ((VmNicConfigCmd)nic.get(1)).getIp()).orElseThrow(() -> new DeployDayuException(DeployDayuError.IP_NOT_FOUND));
    }

    public AttachDiskCmd getAttachDiskCmd(String hostName) {
        return this.attachDiskCmdMap.get(hostName);
    }

    public void setAttachDiskCmd(String hostName, AttachDiskCmd cmd) {
        this.attachDiskCmdMap.put(hostName, cmd);
    }

    public CreateVmByTemplateCmd getCreateVmByTemplateCmd(String hostName) {
        return this.createVmByTemplateCmdMap.get(hostName);
    }

    public void setCreateVmByTemplateCmd(String hostName, CreateVmByTemplateCmd cmd) {
        this.createVmByTemplateCmdMap.put(hostName, cmd);
    }

    public void clearContextInVmDeploy() {
        this.setScriptError("");
        this.hostNameMapToVmId.clear();
        this.eDataInsightVmId = "";
        this.dayuDeployTaskDetailResult = null;
        this.timeDeltaOfLocalToVm = Long.MIN_VALUE;
    }

    public void updateTimeDeltaOfLocalToVm(LongSupplier supplier) {
        if (this.timeDeltaOfLocalToVm == Long.MIN_VALUE) {
            this.timeDeltaOfLocalToVm = supplier.getAsLong();
        }
    }

    public String getSopuser() {
        return this.dayuVmsParams.getDayuPassword().getSopUser();
    }

    public String getRootPassword() {
        return this.dayuVmsParams.getDayuPassword().getDecryptRootPassword();
    }

    private void setVmsParams(DayuVmsParams dayuVmsParams) {
        dayuVmsParams.getDeployDayuVmsParamsEntities().forEach(this::buildVmsParams);
    }

    private void buildVmsParams(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity) {
        this.buildAttachDiskTaskCmd(deployDayuVmsParamsEntity);
        this.buildVmByTemplateTaskCmd(deployDayuVmsParamsEntity);
    }

    private void buildAttachDiskTaskCmd(DeployDayuVmsParamsEntity params) {
        AttachDiskCmd attachDiskCmd = AttachDiskCmd.builder().vmId(() -> TaskContext.get().getVmId()).hostName(params.getCnaName()).diskCmds(params.getDiskCmds()).build();
        this.setAttachDiskCmd(params.getHostName(), attachDiskCmd);
    }

    private void buildVmByTemplateTaskCmd(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity) {
        CreateVmByTemplateCmd createVmByTemplateCmd = ((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)CreateVmByTemplateCmd.builder().taskName(deployDayuVmsParamsEntity.getHostName())).password(DeployDayuContext.getInstance().getRootPassword()).hostName(deployDayuVmsParamsEntity.getHostName()).nicConfigs(deployDayuVmsParamsEntity.getNicConfigs()).cnaName(deployDayuVmsParamsEntity.getCnaName())).vmName(deployDayuVmsParamsEntity.getHostName())).cpuCores(deployDayuVmsParamsEntity.getCpuCores())).datastoreName(deployDayuVmsParamsEntity.getDataStoreName())).memorySizeGb(deployDayuVmsParamsEntity.getMemorySizeGb())).templateId(this::getEDataInsightVmId).vmIdHandler(vmId -> this.setVmId((String)vmId, deployDayuVmsParamsEntity.getHostName()))).isAutoStartVm(false)).build();
        this.setCreateVmByTemplateCmd(deployDayuVmsParamsEntity.getHostName(), createVmByTemplateCmd);
    }

    private void setVmId(String vmId, String hostName) {
        TaskContext.get().setVmId(vmId);
        this.hostNameMapToVmId.put(hostName, vmId);
    }

    @Generated
    public Map<String, String> getHostNameMapToVmId() {
        return this.hostNameMapToVmId;
    }

    @Generated
    public DayuVmsParams getDayuVmsParams() {
        return this.dayuVmsParams;
    }

    @Generated
    public String getDeployServiceState() {
        return this.deployServiceState;
    }

    @Generated
    public void setDeployServiceState(String deployServiceState) {
        this.deployServiceState = deployServiceState;
    }

    @Generated
    public String getScriptError() {
        return this.scriptError;
    }

    @Generated
    public void setScriptError(String scriptError) {
        this.scriptError = scriptError;
    }

    @Generated
    public String getEDataInsightVmId() {
        return this.eDataInsightVmId;
    }

    @Generated
    public void setEDataInsightVmId(String eDataInsightVmId) {
        this.eDataInsightVmId = eDataInsightVmId;
    }

    @Generated
    public String getDayuTemplateVhd() {
        return this.dayuTemplateVhd;
    }

    @Generated
    public void setDayuTemplateVhd(String dayuTemplateVhd) {
        this.dayuTemplateVhd = dayuTemplateVhd;
    }

    @Generated
    public void setDayuTemplateOvf(String dayuTemplateOvf) {
        this.dayuTemplateOvf = dayuTemplateOvf;
    }

    @Generated
    public String getDayuTemplateOvf() {
        return this.dayuTemplateOvf;
    }

    @Generated
    public String getUnzipTemplateFilePath() {
        return this.unzipTemplateFilePath;
    }

    @Generated
    public void setUnzipTemplateFilePath(String unzipTemplateFilePath) {
        this.unzipTemplateFilePath = unzipTemplateFilePath;
    }

    @Generated
    public String getDeployDayuVmsTaskId() {
        return this.deployDayuVmsTaskId;
    }

    @Generated
    public void setDeployDayuVmsTaskId(String deployDayuVmsTaskId) {
        this.deployDayuVmsTaskId = deployDayuVmsTaskId;
    }

    @Generated
    public String getDeployDayuServiceTaskId() {
        return this.deployDayuServiceTaskId;
    }

    @Generated
    public void setDeployDayuServiceTaskId(String deployDayuServiceTaskId) {
        this.deployDayuServiceTaskId = deployDayuServiceTaskId;
    }

    @Generated
    public String getExecuteDayuServiceScriptTaskId() {
        return this.executeDayuServiceScriptTaskId;
    }

    @Generated
    public void setExecuteDayuServiceScriptTaskId(String executeDayuServiceScriptTaskId) {
        this.executeDayuServiceScriptTaskId = executeDayuServiceScriptTaskId;
    }

    @Generated
    public DayuDeployTaskDetailResult getDayuDeployTaskDetailResult() {
        return this.dayuDeployTaskDetailResult;
    }

    @Generated
    public void setDayuDeployTaskDetailResult(DayuDeployTaskDetailResult dayuDeployTaskDetailResult) {
        this.dayuDeployTaskDetailResult = dayuDeployTaskDetailResult;
    }

    @Generated
    public long getTimeDeltaOfLocalToVm() {
        return this.timeDeltaOfLocalToVm;
    }

    private static class DeployDayuVmsContextHolder {
        static final DeployDayuContext INSTANCE = new DeployDayuContext();

        private DeployDayuVmsContextHolder() {
        }
    }
}

