/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.server.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.DayuConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.DayuServiceTaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuDeployTaskDetailResult;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuPassword;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuServiceParam;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuError;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuException;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.server.task.DayuServiceCustomTaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils.SshConnectDayuServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils.VmsTasksOpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.UploadFileProgCallBack;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ConfigFilesUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployDataInsightServiceTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployDataInsightServiceTask.class);
    public static final String TASK_NAME = "init.deploy.dayu.service";
    private static int semaphore = 0;
    private DayuServiceTaskStatus deployEDataInsightStatus;
    private String lastTaskDetailJson;
    private DayuServiceParam deployDayuServiceParam;

    public void beforeExecute() {
        DeployDayuContext.getInstance().setScriptError("");
        this.deployDayuServiceParam = VmsTasksOpUtils.transferVmsToService(DeployDayuContext.getInstance().getDayuVmsParams());
        log.info("start queryDeployDetailTask taskId = {}.", (Object)this.getTaskId());
        DeployDayuContext.getInstance().setExecuteDayuServiceScriptTaskId(this.getTaskId());
        boolean shouldExecuteInit = this.shouldExecuteInit();
        this.deployEDataInsightStatus = DayuServiceTaskStatus.RUNNING;
        if (shouldExecuteInit) {
            this.uploadEDataInsightParams();
            this.invokeInitScript();
        }
    }

    private boolean shouldExecuteInit() {
        return Objects.isNull((Object)this.deployEDataInsightStatus) || DayuServiceTaskStatus.ROLLBACK_SUCCESS.equals((Object)this.deployEDataInsightStatus);
    }

    public void execute() throws TaskException {
        this.queryDeployDetailTask();
    }

    void uploadEDataInsightParams() throws DeployDayuException {
        try (SshSftpService sftpService = SshConnectDayuServiceUtils.getFtpClient();){
            sftpService.connect();
            String installParamsFile = this.getTempCachePath().concat(File.separator).concat("install_parameters.json");
            this.writeFile(installParamsFile, JSON.toJSONString((Object)this.deployDayuServiceParam, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
            boolean isUploadSucc = sftpService.upload(installParamsFile, "/root/eDataInsight", (SftpProgCallback)new UploadFileProgCallBack("/root/eDataInsight", (cmd, detail) -> this.appendTaskDetail((String)detail)));
            log.info("upload install parameters json result : {}.", (Object)isUploadSucc);
        }
        catch (SshException e) {
            log.error("upload package ssh execute error: ", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("upload package ssh connect error: ", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_CONNECT_ERROR);
        }
    }

    void writeFile(String path, String data) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(path);
             FileChannel channel = fileOutputStream.getChannel();
             FileLock lock = channel.tryLock();){
            if (lock == null) {
                throw new DeployDayuException(DeployDayuError.FILE_UTILIZATION_ERROR);
            }
            fileOutputStream.write(data.getBytes(StandardCharsets.UTF_8));
            fileOutputStream.flush();
        }
        catch (DeployDayuException e) {
            log.error("write file error", (Throwable)((Object)e));
            throw new DeployDayuException(DeployDayuError.FILE_UTILIZATION_ERROR);
        }
        catch (IOException e) {
            log.error("write file error", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.FILE_WRITE_ERROR);
        }
    }

    private String getTempCachePath() {
        String templateCache = FilePathValidatorUtils.joinChildPath((String[])new String[]{DayuConstant.BASE_DIR, "template_cache", StringUtils.commonFormatTimeText()});
        File file = new File(templateCache);
        if (!file.exists() && !file.mkdirs()) {
            log.error("TempCachePath create error");
            throw new DeployDayuException(DeployDayuError.UNKNOWN_ERROR);
        }
        return templateCache;
    }

    public void afterExecute() {
        FileOperateUtils.deleteDirectory((String)DayuConstant.TEMPORARY_CACHE);
    }

    /*
     * Unable to fully structure code
     */
    private void queryDeployDetailTask() throws TaskException {
        DeployDataInsightServiceTask.semaphore = 0;
        while (true) {
            ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
            try {
                if (!this.queryDeployDetail()) continue;
            }
            catch (SshException e) {
                if (++DeployDataInsightServiceTask.semaphore >= 10) ** break;
                continue;
                this.deployEDataInsightStatus = DayuServiceTaskStatus.ERROR;
                throw new DeployDayuException(DeployDayuError.DAYU_SSH_CONNECT_ERROR);
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean queryDeployDetail() throws SshException, DeployDayuException {
        try (SshShellService shellClient = SshConnectDayuServiceUtils.getSshShellClientInDayuDeploy();){
            shellClient.connect();
            shellClient.changeRootPermission(DeployDayuContext.getInstance().getRootPassword());
            this.retry(shellClient, this.getTimeout(), TimeUnit.MINUTES);
            String result = shellClient.execCommand("rm -rf /root/eDataInsight");
            log.info("remove root.eDataInsight result:{}", (Object)result);
            this.appendTaskDetail(result);
            boolean bl = true;
            return bl;
        }
        catch (SshException e) {
            log.error("ssh execute error: ", (Throwable)e);
            throw e;
        }
        catch (DeployDayuException e) {
            log.error("deploy eDataInsight service: ", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception e) {
            log.error("ssh connect error: ", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_CONNECT_ERROR);
        }
    }

    private void retry(SshShellService shellClient, int timeout, TimeUnit minutes) throws SshException, DeployDayuException {
        String result;
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(minutes.toSeconds(timeout));
        do {
            ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
            if (timeLimit.isBefore(LocalDateTime.now())) {
                this.deployEDataInsightStatus = DayuServiceTaskStatus.ERROR;
                throw new DeployDayuException(DeployDayuError.DAYU_SERVICE_DEPLOY_ERROR);
            }
            result = this.queryDeployDetail(shellClient);
            if (!StringUtils.isEmpty((CharSequence)result)) continue;
            this.deployEDataInsightStatus = DayuServiceTaskStatus.ERROR;
            throw new DeployDayuException(DeployDayuError.DAYU_QUERY_DEPLOY_DETAIL_ERROR);
        } while (!this.parseDeployDetailResult(result));
    }

    private int getTimeout() {
        int timeout = NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)DayuConstant.CONFIG_PATH, (String)"dayu.deploy.service.timeout").orElse("300"), (int)300);
        log.info("query deploy detail timeout is {}.", (Object)timeout);
        return timeout;
    }

    private String queryDeployDetail(SshShellService shellClient) throws SshException {
        try {
            return shellClient.execCommand("sh /root/eDataInsight/edi-inaas/controller/dayu.main.s query_task_status");
        }
        catch (SshException e) {
            log.error("query deploy detail ssh execute error: ", (Throwable)e);
            throw e;
        }
    }

    private boolean parseDeployDetailResult(String result) throws DeployDayuException {
        String taskDetailJson = this.getTaskDetailJson(StringUtils.defaultString((String)result));
        if (StringUtils.isEmpty((CharSequence)taskDetailJson)) {
            return false;
        }
        if (!Objects.equals(this.lastTaskDetailJson, taskDetailJson)) {
            this.lastTaskDetailJson = taskDetailJson;
            this.appendTaskDetail(taskDetailJson);
        }
        DayuDeployTaskDetailResult dayuDeployTaskDetailResult = (DayuDeployTaskDetailResult)com.alibaba.fastjson2.JSON.parseObject((String)taskDetailJson, DayuDeployTaskDetailResult.class);
        DeployDayuContext.getInstance().setDayuDeployTaskDetailResult(dayuDeployTaskDetailResult);
        return this.checkTaskStatus(dayuDeployTaskDetailResult);
    }

    private String getTaskDetailJson(String result) {
        String taskDetailJson = "";
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(result));){
            taskDetailJson = bufferedReader.lines().collect(Collectors.toList()).stream().filter(line -> line.startsWith("{") && line.endsWith("}")).findFirst().orElse("");
        }
        catch (IOException e) {
            log.error("release resource error.", (Throwable)e);
        }
        return taskDetailJson;
    }

    boolean checkTaskStatus(DayuDeployTaskDetailResult result) throws DeployDayuException {
        if (!"eDI.0000".equals(result.getErrCode())) {
            DeployDayuContext.getInstance().setScriptError(result.getErrMsg());
            throw new DeployDayuException(DeployDayuError.SCRIPT_INVOKE_ERROR, Collections.singletonList(result.getErrMsg()));
        }
        if (result.inStatus(DayuServiceCustomTaskStatus.FAILED)) {
            this.deployEDataInsightStatus = DayuServiceTaskStatus.ERROR;
            throw new DeployDayuException(DeployDayuError.DAYU_SERVICE_DEPLOY_ERROR);
        }
        if (result.inStatus(DayuServiceCustomTaskStatus.PAUSE)) {
            this.deployEDataInsightStatus = DayuServiceTaskStatus.PAUSE;
            throw new DeployDayuException(DeployDayuError.DAYU_SERVICE_DEPLOY_ERROR);
        }
        if (result.inStatus(DayuServiceCustomTaskStatus.ROLLBACK_FAILED)) {
            this.deployEDataInsightStatus = DayuServiceTaskStatus.ROLLBACK_FAILED;
            throw new DeployDayuException(DeployDayuError.DAYU_SERVICE_DEPLOY_ERROR);
        }
        if (result.inStatus(DayuServiceCustomTaskStatus.ROLLING_BACK)) {
            this.deployEDataInsightStatus = DayuServiceTaskStatus.ROLLBACKING;
        }
        if (result.inStatus(DayuServiceCustomTaskStatus.ROLLBACK_SUCCESS)) {
            this.deployEDataInsightStatus = DayuServiceTaskStatus.ROLLBACK_SUCCESS;
            throw new DeployDayuException(DeployDayuError.DAYU_SERVICE_DEPLOY_ERROR);
        }
        if (DayuServiceCustomTaskStatus.PAUSING.getStatusValue().equals(result.getTaskStatus())) {
            this.deployEDataInsightStatus = DayuServiceTaskStatus.PAUSING;
        }
        if (result.inStatus(DayuServiceCustomTaskStatus.FINISHED)) {
            this.deployEDataInsightStatus = DayuServiceTaskStatus.END;
        }
        return result.inStatus(DayuServiceCustomTaskStatus.FINISHED);
    }

    void invokeInitScript() throws TaskException {
        try (SshShellService shellClient = SshConnectDayuServiceUtils.getShellClient();){
            shellClient.connect(1800000);
            this.executeInitSh(shellClient);
            this.executeInstallSh(shellClient);
        }
        catch (DeployDayuException e) {
            log.error("script invoke error: ", (Throwable)((Object)e));
            throw e;
        }
        catch (SshException e) {
            log.error("ssh execute error: ", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error: ", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_CONNECT_ERROR);
        }
    }

    private void executeInstallSh(SshShellService shellClient) throws SshException, TaskException {
        String echoesJson = SshConnectDayuServiceUtils.getEchoesJson(shellClient.execCommand("sh /root/eDataInsight/edi-inaas/controller/dayu.main.s install"));
        log.info("install task sh: {}.", (Object)echoesJson);
        this.appendTaskDetail(echoesJson);
        ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    private void executeInitSh(SshShellService shellClient) throws SshException, TaskException {
        String echoesJson = SshConnectDayuServiceUtils.getEchoesJson(shellClient.execCommandWithTimeout(this.buildInitCmd(), 300));
        log.info("init task sh: {}.", (Object)echoesJson);
        this.appendTaskDetail(echoesJson);
    }

    private String buildInitCmd() {
        DayuPassword dayuPassword = this.deployDayuServiceParam.getDayuPassword();
        String pwd = String.format("(echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';echo '%s';)", dayuPassword.getDecryptSopUser(), dayuPassword.getDecryptOssAdm(), dayuPassword.getDecryptOssUser(), dayuPassword.getDecryptFtpUser(), dayuPassword.getDecryptRedisDbUser(), dayuPassword.getDecryptZenithSys(), dayuPassword.getDecryptAdminWebService(), dayuPassword.getDecryptAdminWebControl(), dayuPassword.getDecryptLdapManager(), dayuPassword.getDecryptKerberosManager(), dayuPassword.getDecryptRootPassword(), dayuPassword.getDecryptOsDefaultPasswd(), StringUtils.isEmpty((CharSequence)this.deployDayuServiceParam.getPacificParams().getPacificHdfsPwd()) ? "ISAC" : this.deployDayuServiceParam.getPacificParams().getDecryptPacificHdfsPwd());
        return pwd.concat(" | ").concat("sh /root/eDataInsight/edi-inaas/controller/dayu.main.s init");
    }

    @Generated
    protected DeployDataInsightServiceTask(DeployDataInsightServiceTaskBuilder<?, ?> b) {
        super(b);
        this.deployEDataInsightStatus = ((DeployDataInsightServiceTaskBuilder)b).deployEDataInsightStatus;
        this.lastTaskDetailJson = ((DeployDataInsightServiceTaskBuilder)b).lastTaskDetailJson;
        this.deployDayuServiceParam = ((DeployDataInsightServiceTaskBuilder)b).deployDayuServiceParam;
    }

    @Generated
    public static DeployDataInsightServiceTaskBuilder<?, ?> builder() {
        return new DeployDataInsightServiceTaskBuilderImpl();
    }

    @Generated
    public DayuServiceTaskStatus getDeployEDataInsightStatus() {
        return this.deployEDataInsightStatus;
    }

    @Generated
    private static final class DeployDataInsightServiceTaskBuilderImpl
    extends DeployDataInsightServiceTaskBuilder<DeployDataInsightServiceTask, DeployDataInsightServiceTaskBuilderImpl> {
        @Generated
        private DeployDataInsightServiceTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DeployDataInsightServiceTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeployDataInsightServiceTask build() {
            return new DeployDataInsightServiceTask(this);
        }
    }

    @Generated
    public static abstract class DeployDataInsightServiceTaskBuilder<C extends DeployDataInsightServiceTask, B extends DeployDataInsightServiceTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private DayuServiceTaskStatus deployEDataInsightStatus;
        @Generated
        private String lastTaskDetailJson;
        @Generated
        private DayuServiceParam deployDayuServiceParam;

        @Generated
        public B deployEDataInsightStatus(DayuServiceTaskStatus deployEDataInsightStatus) {
            this.deployEDataInsightStatus = deployEDataInsightStatus;
            return (B)this.self();
        }

        @Generated
        public B lastTaskDetailJson(String lastTaskDetailJson) {
            this.lastTaskDetailJson = lastTaskDetailJson;
            return (B)this.self();
        }

        @Generated
        public B deployDayuServiceParam(DayuServiceParam deployDayuServiceParam) {
            this.deployDayuServiceParam = deployDayuServiceParam;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DeployDataInsightServiceTask.DeployDataInsightServiceTaskBuilder(super=" + super.toString() + ", deployEDataInsightStatus=" + (Object)((Object)this.deployEDataInsightStatus) + ", lastTaskDetailJson=" + this.lastTaskDetailJson + ", deployDayuServiceParam=" + this.deployDayuServiceParam + ")";
        }
    }
}

