/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.server.task;

import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuError;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuException;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils.SshConnectDayuServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils.VmsTasksOpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.UploadFileProgCallBack;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadSoftWarePackageTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadSoftWarePackageTask.class);
    public static final String TASK_NAME = "upload.software.package";
    private String softwarePackage;

    public void execute() throws TaskException {
        this.softwarePackage = VmsTasksOpUtils.transferVmsToService(DeployDayuContext.getInstance().getDayuVmsParams()).getDayuBaseParams().getSoftPackagePath();
        this.buildNeedDir();
        this.uploadDayuSoftwarePackage();
        this.unzipSoftwarePackage();
    }

    private void buildNeedDir() throws DeployDayuException {
        try (SshShellService shellService = SshConnectDayuServiceUtils.getShellClient();){
            shellService.connect();
            String result = shellService.execCommand(String.format("rm -rf %s", "/root/eDataInsight"));
            log.info("delete upload path file, result : {}.", (Object)result);
            this.appendTaskDetail(result);
            result = shellService.execCommand(String.format("mkdir -p %s", "/root/eDataInsight"));
            this.appendTaskDetail(result);
            log.info("create upload path file, result : {}.", (Object)result);
        }
        catch (SshException e) {
            log.error("creat dir ssh execute error.", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("create dir ssh connect error", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_CONNECT_ERROR);
        }
    }

    private void unzipSoftwarePackage() throws DeployDayuException {
        try (SshShellService shellClient = SshConnectDayuServiceUtils.getShellClient();){
            shellClient.connect();
            int timeout = (int)TimeUnit.MINUTES.toSeconds(5L);
            String softwareFile = "/root/eDataInsight".concat("/").concat(this.getFileName(this.softwarePackage));
            String cmd = String.format("unzip -o %s -d %s", softwareFile, "/root/eDataInsight");
            String result = shellClient.execCommandWithTimeout(cmd, timeout);
            log.info("unzip eDataInsight Package, result = {}.", (Object)result);
            this.appendTaskDetail(cmd);
            cmd = String.format("unzip -o %s -d %s", "/root/eDataInsight".concat("/").concat("edi-inaas.zip"), "/root/eDataInsight");
            result = shellClient.execCommandWithTimeout(cmd, timeout);
            log.info("unzip edi-inaas.zip, result = {}.", (Object)result);
            this.appendTaskDetail(cmd);
            result = shellClient.execCommand(StringUtils.formatTxt((String)"rm -f %s", (Object[])new Object[]{softwareFile}));
            log.info("delete edi software zip, result = {}.", (Object)result);
        }
        catch (SshException e) {
            log.error("unzip package ssh execute error", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("unzip package  ssh connect error", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_CONNECT_ERROR);
        }
    }

    private void uploadDayuSoftwarePackage() throws DeployDayuException {
        try (SshSftpService sftpService = SshConnectDayuServiceUtils.getFtpClient();){
            sftpService.connect();
            boolean isUploadSucc = sftpService.upload(this.softwarePackage, "/root/eDataInsight", (SftpProgCallback)new UploadFileProgCallBack("/root/eDataInsight", (cmd, detail) -> this.appendTaskDetail((String)detail)));
            log.info("upload eDataInsight package file result : {}.", (Object)isUploadSucc);
        }
        catch (SshException e) {
            log.error("upload package ssh execute error: ", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("upload package ssh connect error: ", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_CONNECT_ERROR);
        }
    }

    private String getFileName(String fullPath) {
        return new File(fullPath).getName();
    }

    @Generated
    protected UploadSoftWarePackageTask(UploadSoftWarePackageTaskBuilder<?, ?> b) {
        super(b);
        this.softwarePackage = ((UploadSoftWarePackageTaskBuilder)b).softwarePackage;
    }

    @Generated
    public static UploadSoftWarePackageTaskBuilder<?, ?> builder() {
        return new UploadSoftWarePackageTaskBuilderImpl();
    }

    @Generated
    private static final class UploadSoftWarePackageTaskBuilderImpl
    extends UploadSoftWarePackageTaskBuilder<UploadSoftWarePackageTask, UploadSoftWarePackageTaskBuilderImpl> {
        @Generated
        private UploadSoftWarePackageTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadSoftWarePackageTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadSoftWarePackageTask build() {
            return new UploadSoftWarePackageTask(this);
        }
    }

    @Generated
    public static abstract class UploadSoftWarePackageTaskBuilder<C extends UploadSoftWarePackageTask, B extends UploadSoftWarePackageTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private String softwarePackage;

        @Generated
        public B softwarePackage(String softwarePackage) {
            this.softwarePackage = softwarePackage;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UploadSoftWarePackageTask.UploadSoftWarePackageTaskBuilder(super=" + super.toString() + ", softwarePackage=" + this.softwarePackage + ")";
        }
    }
}

