/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.DayuConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ConfigFilesUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.CryptUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import java.io.File;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

public final class ConsistencyCheckUtils {
    public static boolean consistencyCheck(String path) {
        boolean isCheckConsistency = Boolean.parseBoolean(ConfigFilesUtils.getConfigValueFromCustomFile((String)DayuConstant.CONFIG_PATH, (String)"dayu.deploy.consistencyCheck.switch").orElse("true"));
        if (!isCheckConsistency) {
            return true;
        }
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{path + ConsistencyCheckUtils.getSuffix()})) {
            return false;
        }
        return CryptUtils.verifyConsistencyFileBySign((File)FileUtils.getFile((String[])new String[]{path}), (File)FileUtils.getFile((String[])new String[]{path + ConsistencyCheckUtils.getSuffix()}));
    }

    private static String getSuffix() {
        String consistencyCheckType = ConfigFilesUtils.getConfigValueFromCustomFile((String)DayuConstant.CONFIG_PATH, (String)"dayu.deploy.consistencyCheck.type").orElse("CMS");
        String suffix = "";
        suffix = "SIGN".equals(consistencyCheckType) ? ".sign" : ".p7s";
        return suffix;
    }

    @Generated
    private ConsistencyCheckUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

