/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuDeployTaskDetailResult;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuError;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshConnectDayuServiceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshConnectDayuServiceUtils.class);

    public static SshSftpService getFtpClient() throws SshException {
        return SshManager.createSshSftpService((ClientSession)SshManager.getSession((SshConnInfo)SshConnectDayuServiceUtils.getRootSshConnInfo()));
    }

    public static SshShellService getShellClient() throws SshException {
        return SshManager.createSshShellService((ClientSession)SshManager.getSession((SshConnInfo)SshConnectDayuServiceUtils.getRootSshConnInfo()));
    }

    public static SshShellService getSshShellClientInDayuDeploy() throws SshException {
        ClientSession session = null;
        try {
            session = SshManager.getSession((SshConnInfo)SshConnectDayuServiceUtils.getRootSshConnInfo());
            return SshManager.createSshShellService((ClientSession)session);
        }
        catch (SshException e) {
            log.info("root connect cloudsop1 failed,trying to connect using sopuser");
            try {
                session = SshManager.getSession((SshConnInfo)SshConnectDayuServiceUtils.getSopUserSshConnInfo());
                return SshManager.createSshShellService((ClientSession)session);
            }
            catch (SshException e2) {
                log.info("sopuser connect cloudsop1 failed");
                throw e2;
            }
        }
    }

    private static SshConnInfo getRootSshConnInfo() {
        return SshConnInfo.builder().hostName(DeployDayuContext.getInstance().getCloudSopIp()).userName("root").userPwd(DeployDayuContext.getInstance().getRootPassword()).build();
    }

    private static SshConnInfo getSopUserSshConnInfo() {
        return SshConnInfo.builder().hostName(DeployDayuContext.getInstance().getCloudSopIp()).userName("sopuser").userPwd(DeployDayuContext.getInstance().getSopuser()).build();
    }

    public static String getEchoesJson(String result) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(result));
        String resultJson = bufferedReader.lines().collect(Collectors.toList()).stream().filter(line -> line.startsWith("{") && line.endsWith("}")).findFirst().orElse("");
        DayuDeployTaskDetailResult dayuDeployTaskDetailResult = (DayuDeployTaskDetailResult)JSON.parseObject((String)resultJson, DayuDeployTaskDetailResult.class);
        if (!"eDI.0000".equals(dayuDeployTaskDetailResult.getErrCode())) {
            throw new DeployDayuException(DeployDayuError.SCRIPT_INVOKE_ERROR, Collections.singletonList(dayuDeployTaskDetailResult.getErrMsg()));
        }
        return resultJson;
    }

    @Generated
    private SshConnectDayuServiceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

