/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.DayuConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.DayuServiceTaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.VmTypeEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.CloudSopVmsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuDeployTaskDetailResult;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuServiceParam;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuVmsParams;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DeployDayuVmsParamsEntity;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.NdpVmsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.TaskJsonVo;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuError;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuException;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.server.task.DayuServiceCustomTaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.server.task.DeployDataInsightServiceTask;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.server.task.DeployDayuServiceFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils.SshConnectDayuServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.vms.task.DeployDayuVmsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.vms.task.DeployDayuVmsTaskFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VmsTasksOpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VmsTasksOpUtils.class);
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static boolean startDeployVmsTask() {
        DeployDayuContext.getInstance().clearContextInVmDeploy();
        DeployDayuVmsTask deployDayuVmsTask = DeployDayuVmsTaskFactory.createDeployDayuVmsTask(DeployDayuContext.getInstance().getDayuVmsParams());
        DeployDayuContext.getInstance().setDeployDayuVmsTaskId(deployDayuVmsTask.getTaskId());
        CommonTaskManager.getInstance().addTask((BaseTask)deployDayuVmsTask);
        return CommonTaskManager.getInstance().startTaskById(deployDayuVmsTask.getTaskId());
    }

    public static DeployTaskInfoVo queryDeployDayuTaskDetail(String taskId) {
        DeployTaskInfoVo deployTaskInfoVo = (DeployTaskInfoVo)CommonTaskManager.getInstance().queryTaskDetailById(taskId).orElseThrow(() -> new DeployDayuException(DeployDayuError.TASK_ID_NOT_FOUND_ERROR));
        if (taskId.equals(DeployDayuContext.getInstance().getDeployDayuServiceTaskId())) {
            VmsTasksOpUtils.buildDeployTaskInfoVo(deployTaskInfoVo);
        }
        return deployTaskInfoVo;
    }

    private static void buildDeployTaskInfoVo(DeployTaskInfoVo deployTaskInfoVo) {
        List children = deployTaskInfoVo.getChildren();
        if (children.size() < 2) {
            return;
        }
        DeployTaskDetailVo deployServiceTaskDetailVo = (DeployTaskDetailVo)children.get(1);
        DayuDeployTaskDetailResult dayuDeployTaskDetailResult = DeployDayuContext.getInstance().getDayuDeployTaskDetailResult();
        if (Objects.isNull(dayuDeployTaskDetailResult) || !"eDI.0000".equals(dayuDeployTaskDetailResult.getErrCode())) {
            return;
        }
        if (!dayuDeployTaskDetailResult.getActions().contains("RETRY")) {
            dayuDeployTaskDetailResult.getActions().add("RETRY");
        }
        deployServiceTaskDetailVo.setActions(dayuDeployTaskDetailResult.getActions());
        DeployDayuContext.getInstance().updateTimeDeltaOfLocalToVm(() -> VmsTasksOpUtils.getDelayDuration(dayuDeployTaskDetailResult, deployServiceTaskDetailVo.getBeginTime()));
        deployServiceTaskDetailVo.setChildren(VmsTasksOpUtils.transferDayuServiceResult(dayuDeployTaskDetailResult));
        VmsTasksOpUtils.setTaskStatus(deployServiceTaskDetailVo, deployTaskInfoVo);
        VmsTasksOpUtils.setServiceTaskStatus(deployServiceTaskDetailVo);
    }

    static void setServiceTaskStatus(DeployTaskDetailVo deployServiceTaskDetailVo) {
        List children;
        if (deployServiceTaskDetailVo.getState().equals(TaskStatus.ERROR.name()) && CollectionUtils.isNotEmpty((Collection)(children = deployServiceTaskDetailVo.getChildren()))) {
            ((DeployTaskDetailVo)children.get(children.size() - 1)).setState(TaskStatus.ERROR.name());
        }
    }

    static void setTaskStatus(DeployTaskDetailVo deployServiceTaskDetailVo, DeployTaskInfoVo deployTaskInfoVo) {
        Optional<DeployDataInsightServiceTask> deployEDataInsightServiceTask = CommonTaskManager.getInstance().queryTaskById(DeployDayuContext.getInstance().getDeployDayuServiceTaskId()).map(BaseTask::getSubTasks).filter(CollectionUtils::isNotEmpty).map(subTask -> (BaseTask)subTask.get(1)).filter(DeployDataInsightServiceTask.class::isInstance).map(DeployDataInsightServiceTask.class::cast);
        if (!deployEDataInsightServiceTask.isPresent()) {
            return;
        }
        DayuServiceTaskStatus deployEDataInsightStatus = deployEDataInsightServiceTask.get().getDeployEDataInsightStatus();
        if (Objects.nonNull((Object)deployEDataInsightStatus)) {
            deployServiceTaskDetailVo.setState(deployEDataInsightStatus.name());
            DeployDayuContext.getInstance().setDeployServiceState(deployEDataInsightStatus.name());
        }
        if (deployServiceTaskDetailVo.getState().equals(DayuServiceTaskStatus.PAUSE.name())) {
            deployTaskInfoVo.setState(DayuServiceTaskStatus.PAUSE.name());
        }
        if (deployServiceTaskDetailVo.getState().equals(DayuServiceTaskStatus.ROLLBACK_FAILED.name())) {
            deployServiceTaskDetailVo.setState(DayuServiceTaskStatus.ROLLBACK_FAILED.name());
        }
        if (deployServiceTaskDetailVo.getState().equals(DayuServiceTaskStatus.ROLLBACK_SUCCESS.name())) {
            deployTaskInfoVo.setState(TaskStatus.PAUSE.name());
        }
        if (deployServiceTaskDetailVo.getState().equals(DayuServiceTaskStatus.END.name())) {
            deployTaskInfoVo.setState(TaskStatus.END.name());
            if (Objects.isNull(deployServiceTaskDetailVo.getFinishTime()) || deployServiceTaskDetailVo.getFinishTime().equals(0L)) {
                deployServiceTaskDetailVo.setFinishTime(Long.valueOf(System.currentTimeMillis()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)DeployDayuContext.getInstance().getScriptError())) {
            deployServiceTaskDetailVo.setErrorMsg(DeployDayuContext.getInstance().getScriptError());
            deployServiceTaskDetailVo.setState(TaskStatus.ERROR.name());
            deployTaskInfoVo.setState(TaskStatus.ERROR.name());
        }
    }

    private static List<DeployTaskDetailVo> transferDayuServiceResult(DayuDeployTaskDetailResult dayuDeployTaskDetailResult) {
        return dayuDeployTaskDetailResult.getTaskJson().stream().map(VmsTasksOpUtils::paramsTransfer).collect(Collectors.toList());
    }

    private static long getDelayDuration(DayuDeployTaskDetailResult dayuDeployTaskDetailResult, long beginTime) {
        TaskJsonVo taskJsonVo = dayuDeployTaskDetailResult.getTaskJson().get(0);
        if (StringUtils.isEmpty((CharSequence)taskJsonVo.getFinishTime())) {
            return 0L;
        }
        long serviceTime = beginTime;
        try {
            serviceTime = SIMPLE_DATE_FORMAT.parse(taskJsonVo.getStartTime()).getTime();
        }
        catch (ParseException e) {
            log.error("parse Time error", (Throwable)e);
        }
        return beginTime - serviceTime;
    }

    static DeployTaskDetailVo paramsTransfer(TaskJsonVo result) {
        long startTime = 0L;
        long finishTime = 0L;
        try {
            long duration = DeployDayuContext.getInstance().getTimeDeltaOfLocalToVm();
            if (StringUtils.isNotEmpty((CharSequence)result.getStartTime())) {
                startTime = SIMPLE_DATE_FORMAT.parse(result.getStartTime()).getTime() + duration;
            }
            if (StringUtils.isNotEmpty((CharSequence)result.getFinishTime())) {
                finishTime = SIMPLE_DATE_FORMAT.parse(result.getFinishTime()).getTime() + duration;
            }
        }
        catch (ParseException e) {
            log.error("parse data to long error;", (Throwable)e);
            throw new DeployDayuException(DeployDayuError.UNKNOWN_ERROR);
        }
        return DeployTaskDetailVo.builder().taskId(result.getId()).id(result.getId()).beginTime(Long.valueOf(startTime)).finishTime(Long.valueOf(finishTime)).detail(result.getDetailMsg()).durationTime(result.getDurationTime()).errorMsg(result.getErrMsg()).state(DayuServiceCustomTaskStatus.isFailedStatus(result.getStatus()) ? TaskStatus.ERROR.name() : result.getStatus()).taskName(result.getName()).build();
    }

    public static boolean startDeployDayuService() {
        DayuVmsParams dayuVmsParams = DeployDayuContext.getInstance().getDayuVmsParams();
        VmsTasksOpUtils.clearTaskDetailInfo(dayuVmsParams);
        DayuServiceParam dayuServiceParam = VmsTasksOpUtils.transferVmsToService(dayuVmsParams);
        BaseTask deployDayuServiceTask = DeployDayuServiceFactory.createDeployDayuServiceTask(dayuServiceParam);
        DeployDayuContext.getInstance().setDeployDayuServiceTaskId(deployDayuServiceTask.getTaskId());
        CommonTaskManager.getInstance().addTask(deployDayuServiceTask);
        return CommonTaskManager.getInstance().startTaskById(deployDayuServiceTask.getTaskId());
    }

    static void clearTaskDetailInfo(DayuVmsParams dayuVmsParams) {
        if (!"tool".equals(dayuVmsParams.getDayuBaseParams().getVmDeployType())) {
            DeployDayuContext.getInstance().clearContextInVmDeploy();
        }
    }

    public static DayuServiceParam transferVmsToService(DayuVmsParams dayuVmsParams) {
        return DayuServiceParam.builder().dayuBaseParams(dayuVmsParams.getDayuBaseParams()).dayuPassword(dayuVmsParams.getDayuPassword()).cloudSopVmsParamList(VmsTasksOpUtils.createCloudSopVms(dayuVmsParams)).ndpVmsParamList(VmsTasksOpUtils.createNdpVms(dayuVmsParams)).language(dayuVmsParams.getDayuBaseParams().getLanguage()).floatingIp(dayuVmsParams.getDayuBaseParams().getFloatingIp()).floatingMask(dayuVmsParams.getDayuBaseParams().getFloatingMask()).scenes(dayuVmsParams.getDayuBaseParams().getComponentType()).pacificParams(dayuVmsParams.getPacificParams()).hdfs(dayuVmsParams.getPacificParams().getPacificFlag()).components(VmsTasksOpUtils.buildComponents(dayuVmsParams.getDayuBaseParams().getComponentLists())).build();
    }

    private static List<String> buildComponents(String componentLists) {
        if (StringUtils.isNotEmpty((CharSequence)componentLists)) {
            return Arrays.stream(componentLists.split(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<NdpVmsParam> createNdpVms(DayuVmsParams dayuVmsParams) {
        return dayuVmsParams.getDeployDayuVmsParamsEntities().stream().filter(deployDayuVmsParamsEntity -> deployDayuVmsParamsEntity.getVmTypeEnum() == VmTypeEnum.DAYU_COMPUTE_NODE).map(VmsTasksOpUtils::buildNdpVms).collect(Collectors.toList());
    }

    private static NdpVmsParam buildNdpVms(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity) {
        return NdpVmsParam.builder().name(deployDayuVmsParamsEntity.getHostName()).cnaName(deployDayuVmsParamsEntity.getCnaName()).ip(deployDayuVmsParamsEntity.getNicConfigs().get(0).getIp()).mask(deployDayuVmsParamsEntity.getNicConfigs().get(0).getNetmask()).cpu(deployDayuVmsParamsEntity.getCpuCores()).memory(deployDayuVmsParamsEntity.getMemorySizeGb()).systemDiskSize(92).serviceDiskSize(deployDayuVmsParamsEntity.getDiskCmds().get(0).getQuantityGB()).dataDiskSize(deployDayuVmsParamsEntity.getDiskCmds().get(1).getQuantityGB()).components(VmsTasksOpUtils.buildNdpComponents(deployDayuVmsParamsEntity.getNdpComponentList())).build();
    }

    static List<String> buildNdpComponents(String ndpComponentList) {
        if (StringUtils.isEmpty((CharSequence)ndpComponentList)) {
            return new ArrayList<String>();
        }
        String result = ndpComponentList.toLowerCase(Locale.ROOT).replace(" ", "");
        for (String component : DayuConstant.COMPONENT_LIST) {
            result = result.replaceAll(component.toLowerCase(Locale.ROOT), component);
        }
        return Arrays.stream(result.split(",")).distinct().collect(Collectors.toList());
    }

    private static List<CloudSopVmsParam> createCloudSopVms(DayuVmsParams dayuVmsParams) {
        return dayuVmsParams.getDeployDayuVmsParamsEntities().stream().filter(deployDayuVmsParamsEntity -> deployDayuVmsParamsEntity.getVmTypeEnum() == VmTypeEnum.DAYU_CLOUD_SOP).map(VmsTasksOpUtils::buildCloudSop).collect(Collectors.toList());
    }

    private static CloudSopVmsParam buildCloudSop(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity) {
        return CloudSopVmsParam.builder().name(deployDayuVmsParamsEntity.getHostName()).cnaName(deployDayuVmsParamsEntity.getCnaName()).maintenanceIp(deployDayuVmsParamsEntity.getNicConfigs().get(0).getIp()).maintenanceMask(deployDayuVmsParamsEntity.getNicConfigs().get(0).getNetmask()).omIp(deployDayuVmsParamsEntity.getNicConfigs().get(1).getIp()).omMask(deployDayuVmsParamsEntity.getNicConfigs().get(1).getNetmask()).cpu(deployDayuVmsParamsEntity.getCpuCores()).memory(deployDayuVmsParamsEntity.getMemorySizeGb()).systemDiskSize(92).serviceDiskSize(deployDayuVmsParamsEntity.getDiskCmds().get(0).getQuantityGB()).build();
    }

    public static void retryDeployVmTask() throws DeployDayuException {
        log.info("start clear init task resources");
        VmsTasksOpUtils.clearInitTaskResource();
        log.info("start retry vm deploy task");
        VmsTasksOpUtils.startDeployVmsTask();
    }

    private static boolean isClearSubTaskResources(int subTaskNum) {
        BaseTask baseTask = (BaseTask)CommonTaskManager.getInstance().queryTaskById(DeployDayuContext.getInstance().getDeployDayuVmsTaskId()).orElseThrow(() -> new DeployDayuException(DeployDayuError.TASK_ID_NOT_FOUND_ERROR));
        return CollectionUtils.isNotEmpty((Collection)baseTask.getSubTasks()) && Objects.nonNull(baseTask.getSubTasks().get(1)) && ((BaseTask)baseTask.getSubTasks().get(1)).isFinish();
    }

    private static void clearInitTaskResource() {
        if (VmsTasksOpUtils.isClearSubTaskResources(0)) {
            VmsTasksOpUtils.clearTempDir();
            VmsTasksOpUtils.clearTemplate();
        }
    }

    private static void clearTemplate() {
        log.info("start delete upload template file in fusion compute");
        VmsTasksOpUtils.deleteVm(DeployDayuContext.getInstance().getEDataInsightVmId());
        log.info("finish delete upload template file in fusion compute");
    }

    private static void deleteVm(String templateId) {
        try {
            FcClientService.createApiService((FcLoginInfo)DeployDayuContext.getInstance().getDayuVmsParams().toBaseFcLoginInfo()).deleteVm(templateId);
        }
        catch (FcTaskException e) {
            log.error("clear template failed", (Throwable)e);
        }
    }

    private static void clearTempDir() {
        log.info("start delete temporarily dictionary");
        boolean isSuccess = FileOperateUtils.deleteDirectory((String)DeployDayuContext.getInstance().getUnzipTemplateFilePath());
        log.info("finish delete temporarily dictionary {}", (Object)(isSuccess ? "success" : "failed"));
    }

    public static boolean stopDayuServiceDeploy() {
        try {
            VmsTasksOpUtils.executeDayuCmd("sh /root/eDataInsight/edi-inaas/controller/dayu.main.s stop");
        }
        catch (DeployDayuException e) {
            log.error("execute eDataInsight error");
            return false;
        }
        return true;
    }

    static void executeDayuCmd(String cmd) throws DeployDayuException {
        try (SshShellService shellClient = SshConnectDayuServiceUtils.getShellClient();){
            shellClient.connect();
            SshConnectDayuServiceUtils.getEchoesJson(shellClient.execCommand(cmd));
        }
        catch (DeployDayuException e) {
            log.error("execute eDataInsight shell cmd failed.", (Throwable)((Object)e));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new DeployDayuException(DeployDayuError.DAYU_SSH_OPTION_ERROR);
        }
    }

    public static void retryDayuServiceDeploy(String taskId) {
        if (taskId.equals(DeployDayuContext.getInstance().getExecuteDayuServiceScriptTaskId()) && !DayuServiceTaskStatus.ROLLBACK_SUCCESS.name().equals(DeployDayuContext.getInstance().getDeployServiceState())) {
            VmsTasksOpUtils.executeDayuCmd("sh /root/eDataInsight/edi-inaas/controller/dayu.main.s retry");
        }
        CommonTaskManager.getInstance().retrySubTaskById(taskId);
    }

    public static void rollbackDayuServiceDeploy() {
        VmsTasksOpUtils.executeDayuCmd("sh /root/eDataInsight/edi-inaas/controller/dayu.main.s rollback");
        CommonTaskManager.getInstance().retrySubTaskById(DeployDayuContext.getInstance().getExecuteDayuServiceScriptTaskId());
    }

    public static boolean retryDayuServiceTask() {
        return CommonTaskManager.getInstance().retryAllTaskById(DeployDayuContext.getInstance().getDeployDayuServiceTaskId());
    }

    public static boolean retrySubTask(String taskId) {
        return CommonTaskManager.getInstance().retrySubTaskById(taskId);
    }

    public static void skipTask(String taskId) {
        BaseTask task = (BaseTask)CommonTaskManager.getInstance().queryTaskById(DeployDayuContext.getInstance().getDeployDayuVmsTaskId()).orElseThrow(() -> new DeployDayuException(DeployDayuError.TASK_ID_NOT_FOUND_ERROR));
        VmsTasksOpUtils.setSkipStatus(VmsTasksOpUtils.findSubTasks(task, taskId).orElseThrow(() -> new DeployDayuException(DeployDayuError.TASK_ID_NOT_FOUND_ERROR)));
    }

    private static void setSkipStatus(BaseTask baseTask) {
        if (CollectionUtils.isEmpty((Collection)baseTask.getSubTasks())) {
            return;
        }
        for (BaseTask task : baseTask.getSubTasks()) {
            if (task.getTaskResult().getTaskStatus() != TaskStatus.ERROR && task.getTaskResult().getTaskStatus() != TaskStatus.NOT_START) continue;
            task.getTaskResult().setTaskStatus(TaskStatus.SKIP);
            VmsTasksOpUtils.setSkipStatus(task);
        }
    }

    private static Optional<BaseTask> findSubTasks(BaseTask task, String taskId) {
        if (task.getTaskId().equals(taskId)) {
            return Optional.of(task);
        }
        if (CollectionUtils.isNotEmpty((Collection)task.getSubTasks())) {
            for (BaseTask baseTask : task.getSubTasks()) {
                Optional<BaseTask> optionalBaseTask = VmsTasksOpUtils.findSubTasks(baseTask, taskId);
                if (!optionalBaseTask.isPresent()) continue;
                return optionalBaseTask;
            }
        }
        return Optional.empty();
    }

    @Generated
    private VmsTasksOpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

